/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.entities.RelicExperienceOrbEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RelicExperienceOrbRenderer
extends EntityRenderer<RelicExperienceOrbEntity> {
    public RelicExperienceOrbRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.75f;
    }

    protected int getBlockLightLevel(RelicExperienceOrbEntity entity, BlockPos pos) {
        return Mth.clamp((int)(super.getBlockLightLevel((Entity)entity, pos) + 7), (int)0, (int)15);
    }

    public void render(RelicExperienceOrbEntity entity, float yaw, float pitch, PoseStack poseStack, MultiBufferSource buffer, int light) {
        this.shadowRadius = 0.075f + (float)entity.getStage() * 0.025f;
        poseStack.pushPose();
        VertexConsumer consumer = buffer.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = poseStack.last();
        float scale = (float)(0.5 + Math.sin((float)entity.tickCount * 0.1f) * (double)0.05f);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, 0.2f + (float)entity.getStage() * 0.05f, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        int alpha = (int)Math.min(255.0, 255.0 * (0.75 + Math.sin((float)entity.tickCount * 0.25f) * (double)0.1f));
        RelicExperienceOrbRenderer.vertex(consumer, pose, -0.5f, -0.5f, alpha, 0.0f, 1.0f);
        RelicExperienceOrbRenderer.vertex(consumer, pose, 0.5f, -0.5f, alpha, 1.0f, 1.0f);
        RelicExperienceOrbRenderer.vertex(consumer, pose, 0.5f, 0.5f, alpha, 1.0f, 0.0f);
        RelicExperienceOrbRenderer.vertex(consumer, pose, -0.5f, 0.5f, alpha, 0.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)entity, yaw, pitch, poseStack, buffer, light);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, int alpha, float u, float v) {
        consumer.addVertex(pose, x, y, 0.0f).setColor(255, 255, 255, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(RelicExperienceOrbEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/entities/experience/relics/relic_experience_" + entity.getStage() + ".png"));
    }
}

