/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;

public class GlisteringIvyFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public GlisteringIvyFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        BlockPos pos = context.origin();
        RandomSource randomsource = context.random();
        if (!worldgenlevel.isEmptyBlock(pos)) {
            return false;
        }
        BlockState blockstate = worldgenlevel.getBlockState(pos.above());
        if (!blockstate.is(Blocks.NETHERRACK) && !blockstate.is(RuBlocks.GLISTERING_WART.get())) {
            return false;
        }
        this.placeRoofGlisteringWart((LevelAccessor)worldgenlevel, randomsource, pos);
        this.placeRoofGlisteringIvy((LevelAccessor)worldgenlevel, randomsource, pos);
        return true;
    }

    private void placeRoofGlisteringWart(LevelAccessor level, RandomSource random, BlockPos pos) {
        level.setBlock(pos, RuBlocks.GLISTERING_WART.get().defaultBlockState(), 2);
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            pos1.setWithOffset((Vec3i)pos, random.nextInt(6) - random.nextInt(6), random.nextInt(2) - random.nextInt(5), random.nextInt(6) - random.nextInt(6));
            if (!level.isEmptyBlock((BlockPos)pos1)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = level.getBlockState((BlockPos)pos2.setWithOffset((Vec3i)pos1, direction));
                if (blockstate.is(Blocks.NETHERRACK) || blockstate.is(RuBlocks.GLISTERING_WART.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            level.setBlock((BlockPos)pos1, RuBlocks.GLISTERING_WART.get().defaultBlockState(), 2);
        }
    }

    private void placeRoofGlisteringIvy(LevelAccessor level, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            pos1.setWithOffset((Vec3i)pos, random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(7), random.nextInt(8) - random.nextInt(8));
            if (!level.isEmptyBlock((BlockPos)pos1) || !(blockstate = level.getBlockState(pos1.above())).is(Blocks.NETHERRACK) && !blockstate.is(RuBlocks.GLISTERING_WART.get())) continue;
            int j = Mth.nextInt((RandomSource)random, (int)1, (int)25);
            if (random.nextInt(6) == 0) {
                j *= 2;
            }
            if (random.nextInt(5) == 0) {
                j = 1;
            }
            GlisteringIvyFeature.placeGlisteringIvyColumn(level, random, pos1, j, 17, 25);
        }
    }

    public static void placeGlisteringIvyColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length, int low, int high) {
        for (int i = 0; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)pos)) {
                if (i == length || !level.isEmptyBlock(pos.below())) {
                    level.setBlock((BlockPos)pos, (BlockState)RuBlocks.GLISTERING_IVY.get().defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)low, (int)high))), 2);
                    break;
                }
                level.setBlock((BlockPos)pos, RuBlocks.GLISTERING_IVY_PLANT.get().defaultBlockState(), 2);
            }
            pos.move(Direction.DOWN);
        }
    }
}

