/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;

public class AshVentFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Supplier<ImmutableList<Block>> CANNOT_PLACE_ON = Suppliers.memoize(() -> ImmutableList.of((Object)Blocks.COBBLESTONE, (Object)Blocks.COBBLESTONE_SLAB, (Object)Blocks.COBBLESTONE_STAIRS, (Object)Blocks.MOSSY_COBBLESTONE, (Object)Blocks.MOSSY_COBBLESTONE_SLAB, (Object)Blocks.MOSSY_COBBLESTONE_STAIRS, (Object)Blocks.STONE_BRICKS, (Object)Blocks.MOSSY_STONE_BRICKS, (Object)Blocks.CRACKED_STONE_BRICKS, (Object)Blocks.STONE_BRICK_SLAB, (Object)Blocks.RED_NETHER_BRICKS, (Object)Blocks.RED_NETHER_BRICK_SLAB, (Object[])new Block[]{Blocks.RED_NETHER_BRICK_STAIRS, Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.STONE_BRICK_SLAB, Blocks.COAL_BLOCK, Blocks.NETHERRACK, Blocks.SOUL_SAND, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.POLISHED_ANDESITE_SLAB, Blocks.POLISHED_DIORITE_SLAB, Blocks.POLISHED_GRANITE_SLAB, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.IRON_BARS, Blocks.SOUL_SOIL, Blocks.GRAVEL, Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.LAVA, Blocks.BEDROCK, Blocks.MAGMA_BLOCK, Blocks.SOUL_SAND, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICK_FENCE, Blocks.NETHER_BRICK_STAIRS, Blocks.NETHER_WART, Blocks.CHEST, RuBlocks.ASH_VENT.get(), RuBlocks.DEAD_LEAVES.get()}));

    public AshVentFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        if (level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) {
            this.placeBlob((LevelAccessor)level, pos);
            return true;
        }
        return false;
    }

    public boolean placeBlob(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        if (pos.getY() <= level.getMinBuildHeight() + 3) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int i = random.nextInt(4) + 2;
            int j = random.nextInt(4) + 2;
            int k = random.nextInt(4) + 2;
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)pos.offset(-i, -j, -k), (BlockPos)pos.offset(i, j, k))) {
                if (!(blockpos1.distSqr((Vec3i)pos) <= (double)(f * f)) || !level.getBlockState(blockpos1.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.DOWN) || random.nextInt(5) != 0) continue;
                if (CANNOT_PLACE_ON.get().contains((Object)level.getBlockState(pos.below()))) {
                    return true;
                }
                this.placePillar(level, blockpos1);
            }
            pos = pos.offset(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        return true;
    }

    public boolean placePillar(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(6);
        if (level.isEmptyBlock(pos) && (level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.DOWN) || !level.getBlockState(pos.below()).is(RuBlocks.ASH_VENT.get()))) {
            BlockPos.MutableBlockPos placePos = pos.mutable();
            int count = 0;
            while (level.isEmptyBlock((BlockPos)placePos)) {
                if (level.getBlockState(placePos.below()).is(RuBlocks.ASH_VENT.get())) {
                    return true;
                }
                if (count == size) {
                    return true;
                }
                if (level.isOutsideBuildHeight((BlockPos)placePos)) {
                    return true;
                }
                if (count == size - 1) {
                    if (random.nextInt(6) == 0) {
                        level.setBlock((BlockPos)placePos, RuBlocks.ASH_VENT.get().defaultBlockState(), 2);
                    } else {
                        level.setBlock((BlockPos)placePos, Blocks.BASALT.defaultBlockState(), 2);
                    }
                } else {
                    level.setBlock((BlockPos)placePos, Blocks.BASALT.defaultBlockState(), 2);
                }
                placePos.move(Direction.UP);
                ++count;
            }
            return true;
        }
        return true;
    }
}

