/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.other;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;

public class SpanishMossBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<? extends SpanishMossBlock> CODEC = SpanishMossBlock.simpleCodec(SpanishMossBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public SpanishMossBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)random);
    }

    protected Block getBodyBlock() {
        return RuBlocks.SPANISH_MOSS_PLANT.get();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockState = level.getBlockState(blockPos);
        if (!this.canAttachTo(blockState)) {
            return false;
        }
        return blockState.is((Block)this.getHeadBlock()) || blockState.is(this.getBodyBlock()) || blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES);
    }

    protected boolean canGrowInto(BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }
}

