/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plains_dirt;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.plains_dirt.SpreadingPlainsDirtBlock;

public class SiltGrassBlock
extends SpreadingPlainsDirtBlock
implements BonemealableBlock {
    public SiltGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.above();
        BlockState blockState = Blocks.SHORT_GRASS.defaultBlockState();
        Optional optional = level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockPos1 = blockPos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockPos1 = blockPos1.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(blockPos1).isCollisionShapeFullBlock((BlockGetter)level, blockPos1)) continue block0;
            }
            BlockState blockState1 = level.getBlockState(blockPos1);
            if (blockState1.is(blockState.getBlock()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)blockState.getBlock()).performBonemeal(level, random, blockPos1, blockState1);
            }
            if (!blockState1.isAir()) continue;
            if (random.nextInt(8) == 0) {
                List list = ((Biome)level.getBiome(blockPos1).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).config()).feature();
            } else {
                if (!optional.isPresent()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, blockPos1);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (SiltGrassBlock.playerHasShieldUseIntent(player, interactionHand)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof ShovelItem) {
            BlockState newBlockState = this.evaluateFlattenedState(level, pos, player, state);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            level.setBlock(pos, newBlockState, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockState));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.getItem() instanceof HoeItem && level.getBlockState(pos.above()).isAir()) {
            BlockState newBlockState = this.evaluateTilledState(level, pos, player, state);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            level.setBlock(pos, newBlockState, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockState));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private BlockState evaluateFlattenedState(Level level, BlockPos pos, @Nullable Player player, BlockState state) {
        BlockState flattenedState = RuBlocks.SILT_DIRT_PATH.get().defaultBlockState();
        level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        return flattenedState;
    }

    private BlockState evaluateTilledState(Level level, BlockPos pos, @Nullable Player player, BlockState state) {
        BlockState tilledState = RuBlocks.SILT_FARMLAND.get().defaultBlockState();
        level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        return tilledState;
    }

    private static boolean playerHasShieldUseIntent(Player player, InteractionHand interactionHand) {
        return interactionHand.equals((Object)InteractionHand.MAIN_HAND) && player.getOffhandItem().is(Items.SHIELD) && !player.isSecondaryUseActive();
    }
}

