/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WillowFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> WillowFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)placer).and(placer.group((App)IntProvider.codec((int)4, (int)16).fieldOf("height").forGetter(height -> height.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("flower_decoration_chance").forGetter(flowerChance -> Float.valueOf(flowerChance.flowerDecorationChance)))).apply((Applicative)placer, WillowFoliagePlacer::new));
    public static FoliagePlacerType<?> WILLOW_FOLIAGE_PLACER = new FoliagePlacerType(CODEC);
    private final IntProvider height;
    private final float flowerDecorationChance;

    protected FoliagePlacerType<?> type() {
        return WILLOW_FOLIAGE_PLACER;
    }

    public WillowFoliagePlacer(IntProvider ip1, IntProvider ip2, IntProvider height, float flowerDecorationChance) {
        super(ip1, ip2);
        this.height = height;
        this.flowerDecorationChance = flowerDecorationChance;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfig, int p_272975_, FoliagePlacer.FoliageAttachment foliage, int j, int k, int height) {
        boolean flag = foliage.doubleTrunk();
        BlockPos blockpos = foliage.pos().above(height);
        int i = k + foliage.radiusOffset() - 1;
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos);
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.east().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.west().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().west().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().west().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().east().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().east().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().north());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().east().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().west().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().west());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().west());
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south().west());
        }
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().west().west());
        }
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().east());
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().north().east());
        }
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().east().east());
        }
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().east());
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south().east());
        }
        if (random.nextInt(3) == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().east().east());
        }
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().north());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().south());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().east());
        WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.east().east());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.west().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().west().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().west().west());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north().east());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().east().east());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south().east());
        WillowFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().east().east());
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return this.height.sample(random);
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int i, int j, int k, int l, boolean b) {
        return false;
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = treeConfiguration.foliageProvider.getState(random, pos);
        if (blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, p_225638_ -> p_225638_.isSourceOfType((Fluid)Fluids.WATER))));
        }
        setter.set(pos, blockstate);
        return true;
    }

    protected static void placeHangingLeaves(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        int type = random.nextInt(3);
        if (type == 0) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        } else if (type == 1) {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below());
        } else {
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below());
            WillowFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below().below());
        }
    }
}

