/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei.categories;

import com.mrcrayfish.furniture.refurbished.compat.jei.Plugin;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FurnitureRecipeCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector2i;

public class WorkbenchConstructingCategory
extends FurnitureRecipeCategory<WorkbenchContructingRecipe> {
    public static final RecipeType<WorkbenchContructingRecipe> TYPE = RecipeType.create((String)"refurbished_furniture", (String)"workbench_constructing", WorkbenchContructingRecipe.class);
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private List<Pair<Vector2i, IDrawable>> slots = new ArrayList<Pair<Vector2i, IDrawable>>();

    public WorkbenchConstructingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(Plugin.TEXTURES_2, 0, 0, 118, 64);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.WORKBENCH.get()));
    }

    public RecipeType<WorkbenchContructingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Utils.translation("jei_category", "workbench_constructing", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchContructingRecipe recipe, IFocusGroup focuses) {
        this.slots.clear();
        NonNullList<StackedIngredient> materials = recipe.getMaterials();
        int left = 6;
        int top = 6;
        int slotSize = 18;
        int boxSize = 54;
        int width = slotSize * Mth.clamp((int)materials.size(), (int)1, (int)3);
        int height = slotSize * Mth.clamp((int)Mth.ceil((float)((float)materials.size() / 3.0f)), (int)1, (int)3);
        for (int i = 0; i < materials.size(); ++i) {
            int x = left + i % 3 * slotSize + (boxSize - width) / 2;
            int y = top + i / 3 * slotSize + (boxSize - height) / 2;
            StackedIngredient material = (StackedIngredient)materials.get(i);
            List<ItemStack> stacks = Arrays.stream(material.ingredient().getItems()).map(stack -> {
                ItemStack copy = stack.copy();
                copy.setCount(material.count());
                return copy;
            }).toList();
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(stacks);
            this.slots.add((Pair<Vector2i, IDrawable>)Pair.of((Object)new Vector2i(x - 1, y - 1), (Object)this.helper.createDrawable(Plugin.TEXTURES_2, 0, 64, 18, 18)));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 24).addItemStack(Plugin.getResult(recipe));
    }

    public void draw(WorkbenchContructingRecipe recipe, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slots.forEach(pair -> {
            Vector2i pos = (Vector2i)pair.left();
            ((IDrawable)pair.right()).draw(graphics, pos.x(), pos.y());
        });
    }
}

