/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.query.parser;

import com.refinedmods.refinedstorage.query.lexer.Token;
import com.refinedmods.refinedstorage.query.lexer.TokenType;
import com.refinedmods.refinedstorage.query.parser.Associativity;
import com.refinedmods.refinedstorage.query.parser.Operator;
import com.refinedmods.refinedstorage.query.parser.ParserException;
import com.refinedmods.refinedstorage.query.parser.ParserOperatorMappings;
import com.refinedmods.refinedstorage.query.parser.node.BinOpNode;
import com.refinedmods.refinedstorage.query.parser.node.LiteralNode;
import com.refinedmods.refinedstorage.query.parser.node.Node;
import com.refinedmods.refinedstorage.query.parser.node.ParenNode;
import com.refinedmods.refinedstorage.query.parser.node.UnaryOpNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Parser {
    private final List<Token> tokens;
    private final List<Node> nodes = new ArrayList<Node>();
    private final ParserOperatorMappings operatorMappings;
    private int position = 0;

    public Parser(List<Token> tokens, ParserOperatorMappings operatorMappings) {
        this.tokens = tokens;
        this.operatorMappings = operatorMappings;
    }

    public void parse() {
        while (this.isNotEof()) {
            Node node = this.parseExpression(0);
            this.nodes.add(node);
        }
    }

    private Node parseExpression(int minPrecedence) {
        Node lhs = this.parseAtom();
        Token cur = this.currentOrNull();
        while (cur != null && cur.type() == TokenType.BIN_OP && this.operatorMappings.getOperator(cur).level() >= minPrecedence) {
            Operator currentOp = this.operatorMappings.getOperator(cur);
            int nextMinPrecedence = currentOp.associativity() == Associativity.LEFT ? currentOp.level() + 1 : currentOp.level();
            this.next();
            if (!this.isNotEof()) {
                throw new ParserException("Unfinished binary operator expression", cur);
            }
            Node rhs = this.parseExpression(nextMinPrecedence);
            lhs = new BinOpNode(lhs, rhs, cur);
            cur = this.currentOrNull();
        }
        return lhs;
    }

    private Node parseAtom() {
        return this.parseParen();
    }

    private Node parseParen() {
        Token current = this.current();
        if (current.type() == TokenType.PAREN_OPEN) {
            Token currentAfterExpression;
            this.next();
            if (!this.isNotEof()) {
                throw new ParserException("Unclosed parenthesis", current);
            }
            ArrayList<Node> nodesInParen = new ArrayList<Node>();
            do {
                Node node = this.parseExpression(0);
                nodesInParen.add(node);
                currentAfterExpression = this.currentOrNull();
                if (currentAfterExpression != null) continue;
                throw new ParserException("Expected ')'", this.tokens.getLast());
            } while (currentAfterExpression.type() != TokenType.PAREN_CLOSE || !")".equals(currentAfterExpression.content()));
            this.next();
            return new ParenNode(nodesInParen);
        }
        return this.parseUnaryOp();
    }

    private Node parseUnaryOp() {
        Token maybeUnaryOp = this.current();
        if (maybeUnaryOp.type() == TokenType.UNARY_OP) {
            this.next();
            if (!this.isNotEof()) {
                throw new ParserException("Unary operator has no target", maybeUnaryOp);
            }
            return new UnaryOpNode(this.parseAtom(), maybeUnaryOp);
        }
        return this.parseLiteral();
    }

    private Node parseLiteral() {
        Token current = this.current();
        if (current.type() == TokenType.IDENTIFIER || current.type() == TokenType.FLOATING_NUMBER || current.type() == TokenType.INTEGER_NUMBER) {
            this.next();
            return new LiteralNode(current);
        }
        throw new ParserException("Unexpected token " + current.content(), current);
    }

    private boolean isNotEof() {
        return this.position < this.tokens.size();
    }

    private void next() {
        ++this.position;
    }

    private Token current() {
        return this.tokens.get(this.position);
    }

    @Nullable
    private Token currentOrNull() {
        return this.isNotEof() ? this.current() : null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }
}

