/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.query.lexer;

import com.refinedmods.refinedstorage.query.lexer.LexerException;
import com.refinedmods.refinedstorage.query.lexer.LexerPosition;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMapping;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMappings;
import com.refinedmods.refinedstorage.query.lexer.Source;
import com.refinedmods.refinedstorage.query.lexer.Token;
import com.refinedmods.refinedstorage.query.lexer.TokenPosition;
import com.refinedmods.refinedstorage.query.lexer.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;

public class Lexer {
    private final Source source;
    private final List<Token> tokens = new ArrayList<Token>();
    private final LexerPosition position = new LexerPosition();
    private final LexerTokenMappings tokenMappings;

    public Lexer(Source source, LexerTokenMappings tokenMappings) {
        this.source = source;
        this.tokenMappings = tokenMappings;
    }

    public void scan() {
        while (this.isNotEof()) {
            char current = this.current();
            if (current == '\r') {
                this.position.advanceAndReset();
                continue;
            }
            if (current == '\n') {
                this.position.advance();
                this.position.nextLine();
                this.position.reset();
                continue;
            }
            if (current == ' ') {
                this.position.advanceAndReset();
                continue;
            }
            if (this.tokenMappings.hasMapping(this.position, this.source)) {
                LexerTokenMapping mapping = Objects.requireNonNull(this.tokenMappings.findMapping(this.position, this.source));
                this.position.advance(mapping.value().length());
                this.addToken(mapping.type());
                continue;
            }
            if (Character.isDigit(current)) {
                this.scanNumber();
                continue;
            }
            if (current == '\"') {
                this.scanString();
                continue;
            }
            if (this.isValidIdentifier(current)) {
                this.scanIdentifier();
                continue;
            }
            this.position.advance();
            throw new LexerException(this.position.createRange(), "Unexpected '" + current + "'");
        }
    }

    private boolean isValidIdentifier(char c) {
        return Character.isLetterOrDigit(c);
    }

    private void scanNumber() {
        while (this.isNotEof() && Character.isDigit(this.current())) {
            this.position.advance();
        }
        if (this.isNotEof() && this.current() == '.') {
            this.position.advance();
            if (!this.isNotEof()) {
                throw new LexerException(this.position.createRange(), "Unexpected end of number");
            }
            if (!Character.isDigit(this.current())) {
                throw new LexerException(this.position.createRange(), "Invalid floating point number");
            }
            while (this.isNotEof() && Character.isDigit(this.current())) {
                this.position.advance();
            }
            this.addToken(TokenType.FLOATING_NUMBER);
        } else {
            this.addToken(TokenType.INTEGER_NUMBER);
        }
    }

    private void scanIdentifier() {
        while (this.isNotEof() && this.isValidIdentifier(this.current())) {
            this.position.advance();
        }
        this.addToken(TokenType.IDENTIFIER);
    }

    private void scanString() {
        this.position.advance();
        while (this.isNotEof() && this.current() != '\"') {
            this.position.advance();
        }
        if (!this.isNotEof()) {
            throw new LexerException(this.position.createRange(), "Unexpected end of string");
        }
        this.position.advance();
        this.addToken(TokenType.IDENTIFIER, content -> content.substring(1, content.length() - 1));
    }

    private boolean isNotEof() {
        return this.position.getEndIndex() < this.source.content().length();
    }

    private char current() {
        return this.source.content().charAt(this.position.getEndIndex());
    }

    private void addToken(TokenType type) {
        this.addToken(type, content -> content);
    }

    private void addToken(TokenType type, UnaryOperator<String> contentModifier) {
        String tokenContent = (String)contentModifier.apply(this.source.content().substring(this.position.getStartIndex(), this.position.getEndIndex()));
        TokenPosition tokenPosition = new TokenPosition(this.source, this.position.createRange());
        this.tokens.add(new Token(tokenContent, type, tokenPosition));
        this.position.reset();
    }

    public List<Token> getTokens() {
        return this.tokens;
    }
}

