/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ForgeHandlerUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemHandlerExtractableStorage
implements ExtractableStorage {
    private final CapabilityCache capabilityCache;

    public ItemHandlerExtractableStorage(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> ForgeHandlerUtil.getCurrentAmount(itemHandler, itemResource.toItemStack())).orElse(0L);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> this.extract(amount, action, (IItemHandler)itemHandler, itemResource.toItemStack(amount))).orElse(0L);
    }

    private long extract(long amount, Action action, IItemHandler itemHandler, ItemStack stack) {
        long extracted = 0L;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            long toExtract;
            boolean relevant = ItemStack.isSameItemSameComponents((ItemStack)itemHandler.getStackInSlot(slot), (ItemStack)stack);
            if (!relevant) continue;
            if ((extracted += (long)itemHandler.extractItem(slot, (int)(toExtract = amount - extracted), action == Action.SIMULATE).getCount()) >= amount) break;
        }
        return extracted;
    }
}

