/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ForgeHandlerUtil;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidHandlerInsertableStorage
implements InsertableStorage {
    private final CapabilityCache capabilityCache;

    public FluidHandlerInsertableStorage(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        return this.capabilityCache.getFluidHandler().map(fluidHandler -> ForgeHandlerUtil.getCurrentAmount(fluidHandler, fluidResource)).orElse(0L);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        return this.capabilityCache.getFluidHandler().map(fluidHandler -> this.insert(fluidResource, amount, action, (IFluidHandler)fluidHandler)).orElse(0L);
    }

    private long insert(FluidResource resource, long amount, Action action, IFluidHandler fluidHandler) {
        FluidStack stack = VariantUtil.toFluidStack(resource, amount);
        return fluidHandler.fill(stack, VariantUtil.toFluidAction(action));
    }
}

