/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.CursorItemHandler;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ItemHandlerExtractableStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class ItemGridInsertionStrategy
implements GridInsertionStrategy {
    private final AbstractContainerMenu containerMenu;
    private final GridOperations gridOperations;
    private final CursorItemHandler playerCursorItemHandler;

    public ItemGridInsertionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.containerMenu = containerMenu;
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerCursorItemHandler = new CursorItemHandler(containerMenu);
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        ItemStack carried = this.containerMenu.getCarried();
        if (carried.isEmpty()) {
            return false;
        }
        ItemResource itemResource = ItemResource.ofItemStack(carried);
        this.gridOperations.insert(itemResource, insertMode, new ItemHandlerExtractableStorage(CapabilityCache.ofItemHandler(this.playerCursorItemHandler)));
        return true;
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        Slot slot = this.containerMenu.getSlot(slotIndex);
        RangedWrapper storage = new RangedWrapper((IItemHandlerModifiable)new InvWrapper(slot.container), slot.getContainerSlot(), slot.getContainerSlot() + 1);
        ItemStack itemStackInSlot = storage.getStackInSlot(0);
        if (itemStackInSlot.isEmpty()) {
            return false;
        }
        ItemResource itemResource = ItemResource.ofItemStack(itemStackInSlot);
        this.gridOperations.insert(itemResource, GridInsertMode.ENTIRE_RESOURCE, new ItemHandlerExtractableStorage(CapabilityCache.ofItemHandler((IItemHandler)storage)));
        return true;
    }
}

