/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.refinedmods.refinedstorage.common.AbstractClientModInitializer;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternBlockEntityWithoutLevelRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItemColor;
import com.refinedmods.refinedstorage.common.autocrafting.PatternTooltipCache;
import com.refinedmods.refinedstorage.common.configurationcard.ConfigurationCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.controller.ControllerItemPropertyFunction;
import com.refinedmods.refinedstorage.common.networking.NetworkCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.security.SecurityCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntityRenderer;
import com.refinedmods.refinedstorage.common.support.network.item.NetworkItemPropertyFunction;
import com.refinedmods.refinedstorage.common.support.tooltip.CompositeClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinationClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.autocrafting.PatternGeometryLoader;
import com.refinedmods.refinedstorage.neoforge.networking.CableGeometryLoader;
import com.refinedmods.refinedstorage.neoforge.storage.diskdrive.DiskDriveBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.neoforge.storage.diskdrive.DiskDriveGeometryLoader;
import com.refinedmods.refinedstorage.neoforge.storage.diskinterface.DiskInterfaceBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.neoforge.storage.diskinterface.DiskInterfaceGeometryLoader;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.PortableGridBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.PortableGridGeometryLoader;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;

public final class ClientModInitializer
extends AbstractClientModInitializer {
    private ClientModInitializer() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        NeoForge.EVENT_BUS.addListener(ClientModInitializer::onKeyInput);
        NeoForge.EVENT_BUS.addListener(ClientModInitializer::onMouseInput);
        e.enqueueWork(ClientModInitializer::registerModelPredicates);
        e.enqueueWork(ClientModInitializer::registerItemProperties);
        ClientModInitializer.registerBlockEntityRenderer();
        ClientModInitializer.registerResourceRendering();
        ClientModInitializer.registerAlternativeGridHints();
        ClientModInitializer.registerDiskModels();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key e) {
        ClientModInitializer.handleInputEvents();
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre e) {
        ClientModInitializer.handleInputEvents();
    }

    private static void registerModelPredicates() {
        Items.INSTANCE.getControllers().forEach(controllerBlockItem -> ItemProperties.register((Item)((Item)controllerBlockItem.get()), (ResourceLocation)IdentifierUtil.createIdentifier("stored_in_controller"), (ItemPropertyFunction)new ControllerItemPropertyFunction()));
    }

    @SubscribeEvent
    public static void onRegisterCustomModels(ModelEvent.RegisterGeometryLoaders e) {
        ClientModInitializer.registerDiskModels();
        e.register(ContentIds.PATTERN, (IGeometryLoader)new PatternGeometryLoader());
        e.register(ContentIds.DISK_DRIVE, (IGeometryLoader)new DiskDriveGeometryLoader());
        e.register(ContentIds.PORTABLE_GRID, (IGeometryLoader)new PortableGridGeometryLoader());
        e.register(ContentIds.DISK_INTERFACE, (IGeometryLoader)new DiskInterfaceGeometryLoader());
        e.register(ContentIds.CABLE, (IGeometryLoader)new CableGeometryLoader());
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(final RegisterMenuScreensEvent e) {
        ClientModInitializer.registerScreens(new AbstractClientModInitializer.ScreenRegistration(){

            @Override
            public <M extends AbstractContainerMenu, U extends Screen> void register(MenuType<? extends M> type, AbstractClientModInitializer.ScreenConstructor<M, U> factory) {
                e.register(type, factory::create);
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent e) {
        KeyMapping focusSearchBarKeyBinding = new KeyMapping(ContentNames.FOCUS_SEARCH_BAR_TRANSLATION_KEY, InputConstants.Type.KEYSYM, 258, "mod.refinedstorage");
        e.register(focusSearchBarKeyBinding);
        KeyMappings.INSTANCE.setFocusSearchBar(focusSearchBarKeyBinding);
        KeyMapping clearCraftingGridMatrixToNetwork = new KeyMapping(ContentNames.CLEAR_CRAFTING_MATRIX_TO_NETWORK_TRANSLATION_KEY, (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 88, "mod.refinedstorage");
        e.register(clearCraftingGridMatrixToNetwork);
        KeyMappings.INSTANCE.setClearCraftingGridMatrixToNetwork(clearCraftingGridMatrixToNetwork);
        KeyMapping clearCraftingGridMatrixToInventory = new KeyMapping(ContentNames.CLEAR_CRAFTING_MATRIX_TO_INVENTORY_TRANSLATION_KEY, InputConstants.UNKNOWN.getValue(), "mod.refinedstorage");
        e.register(clearCraftingGridMatrixToInventory);
        KeyMappings.INSTANCE.setClearCraftingGridMatrixToInventory(clearCraftingGridMatrixToInventory);
        KeyMapping openWirelessGrid = new KeyMapping(ContentNames.OPEN_WIRELESS_GRID_TRANSLATION_KEY, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "mod.refinedstorage");
        e.register(openWirelessGrid);
        KeyMappings.INSTANCE.setOpenWirelessGrid(openWirelessGrid);
        KeyMapping openPortableGrid = new KeyMapping(ContentNames.OPEN_PORTABLE_GRID_TRANSLATION_KEY, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "mod.refinedstorage");
        e.register(openPortableGrid);
        KeyMappings.INSTANCE.setOpenPortableGrid(openPortableGrid);
        KeyMapping openWirelessAutocraftingMonitor = new KeyMapping(ContentNames.OPEN_WIRELESS_AUTOCRAFTING_MONITOR_TRANSLATION_KEY, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "mod.refinedstorage");
        e.register(openWirelessAutocraftingMonitor);
        KeyMappings.INSTANCE.setOpenWirelessAutocraftingMonitor(openWirelessAutocraftingMonitor);
    }

    private static void registerBlockEntityRenderer() {
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getDiskDrive(), ctx -> new DiskDriveBlockEntityRendererImpl());
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getStorageMonitor(), ctx -> new StorageMonitorBlockEntityRenderer());
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getPortableGrid(), ctx -> new PortableGridBlockEntityRendererImpl());
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getCreativePortableGrid(), ctx -> new PortableGridBlockEntityRendererImpl());
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getDiskInterface(), ctx -> new DiskInterfaceBlockEntityRendererImpl());
    }

    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item e) {
        e.register((ItemColor)new PatternItemColor(), new ItemLike[]{Items.INSTANCE.getPattern()});
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent e) {
        e.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return PatternBlockEntityWithoutLevelRenderer.getInstance();
            }
        }, new Item[]{Items.INSTANCE.getPattern()});
    }

    @SubscribeEvent
    public static void onRegisterTooltipFactories(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(AbstractUpgradeItem.UpgradeDestinationTooltipComponent.class, component -> new CompositeClientTooltipComponent(List.of(new UpgradeDestinationClientTooltipComponent(component.destinations()), HelpClientTooltipComponent.create(component.helpText()))));
        e.register(HelpTooltipComponent.class, component -> HelpClientTooltipComponent.create(component.text()));
        e.register(RegulatorUpgradeItem.RegulatorTooltipComponent.class, component -> ClientModInitializer.createRegulatorUpgradeClientTooltipComponent(component.destinations(), component.configuredResource(), component.helpText()));
        e.register(PatternItem.CraftingPatternTooltipComponent.class, PatternTooltipCache::getComponent);
        e.register(PatternItem.ProcessingPatternTooltipComponent.class, PatternTooltipCache::getComponent);
        e.register(PatternItem.StonecutterPatternTooltipComponent.class, PatternTooltipCache::getComponent);
        e.register(PatternItem.SmithingTablePatternTooltipComponent.class, PatternTooltipCache::getComponent);
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent e) {
        e.registerReloadListener((PreparableReloadListener)PatternBlockEntityWithoutLevelRenderer.getInstance());
    }

    private static void registerItemProperties() {
        ItemProperties.register((Item)Items.INSTANCE.getWirelessGrid(), (ResourceLocation)NetworkItemPropertyFunction.NAME, (ItemPropertyFunction)new NetworkItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getCreativeWirelessGrid(), (ResourceLocation)NetworkItemPropertyFunction.NAME, (ItemPropertyFunction)new NetworkItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getConfigurationCard(), (ResourceLocation)ConfigurationCardItemPropertyFunction.NAME, (ItemPropertyFunction)new ConfigurationCardItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getNetworkCard(), (ResourceLocation)NetworkCardItemPropertyFunction.NAME, (ItemPropertyFunction)new NetworkCardItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getSecurityCard(), (ResourceLocation)SecurityCardItemPropertyFunction.NAME, (ItemPropertyFunction)new SecurityCardItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getWirelessAutocraftingMonitor(), (ResourceLocation)NetworkItemPropertyFunction.NAME, (ItemPropertyFunction)new NetworkItemPropertyFunction());
        ItemProperties.register((Item)Items.INSTANCE.getCreativeWirelessAutocraftingMonitor(), (ResourceLocation)NetworkItemPropertyFunction.NAME, (ItemPropertyFunction)new NetworkItemPropertyFunction());
    }
}

