/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class UpgradeDestinationClientTooltipComponent
implements ClientTooltipComponent {
    private final Set<UpgradeMapping> mappings;

    public UpgradeDestinationClientTooltipComponent(Set<UpgradeMapping> mappings) {
        this.mappings = mappings;
    }

    public int getHeight() {
        return 18 * this.mappings.size();
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int yy = y;
        for (UpgradeMapping mapping : this.mappings) {
            this.renderMapping(font, x, yy, graphics, mapping);
            yy += 18;
        }
    }

    private void renderMapping(Font font, int x, int y, GuiGraphics graphics, UpgradeMapping mapping) {
        ItemStack destinationStack = mapping.destination().getStackRepresentation();
        graphics.renderItem(destinationStack, x, y);
        graphics.renderItemDecorations(font, destinationStack, x, y);
        graphics.drawString(font, (Component)mapping.destinationDisplayName().copy().withStyle(ChatFormatting.GRAY), x + 16 + 4, y + 4, 0xAAAAAA);
    }

    public int getWidth(Font font) {
        int width = 0;
        for (UpgradeMapping destination : this.mappings) {
            int destinationWidth = 20 + font.width((FormattedText)destination.destinationDisplayName());
            if (destinationWidth <= width) continue;
            width = destinationWidth;
        }
        return width;
    }
}

