/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.amount.PriorityScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class StoragePrioritySideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "priority");
    private static final MutableComponent INSERT_EXTRACT_TITLE = IdentifierUtil.createTranslation("gui", "insert_extract_priority");
    private static final MutableComponent INSERT_TITLE = IdentifierUtil.createTranslation("gui", "insert_priority");
    private static final MutableComponent EXTRACT_TITLE = IdentifierUtil.createTranslation("gui", "extract_priority");
    private static final Component HELP = IdentifierUtil.createTranslation("gui", "priority.storage_help");
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("widget/side_button/priority");
    private final ClientProperty<Integer> insertProperty;
    private final ClientProperty<Integer> extractProperty;

    public StoragePrioritySideButtonWidget(ClientProperty<Integer> insertProperty, ClientProperty<Integer> extractProperty, Inventory playerInventory, Screen parent) {
        super(StoragePrioritySideButtonWidget.createPressAction(insertProperty, extractProperty, playerInventory, parent));
        this.insertProperty = insertProperty;
        this.extractProperty = extractProperty;
    }

    private static Button.OnPress createPressAction(ClientProperty<Integer> insertProperty, ClientProperty<Integer> extractProperty, Inventory playerInventory, Screen parent) {
        return btn -> {
            IntConsumer listener;
            int priority;
            MutableComponent title;
            if (StoragePrioritySideButtonWidget.isModifyingInsert()) {
                title = INSERT_TITLE;
                priority = insertProperty.get();
                listener = insertProperty::setValue;
            } else if (StoragePrioritySideButtonWidget.isModifyingExtract()) {
                title = EXTRACT_TITLE;
                priority = extractProperty.get();
                listener = extractProperty::setValue;
            } else {
                title = INSERT_EXTRACT_TITLE;
                priority = insertProperty.get();
                listener = value -> {
                    insertProperty.setValue(value);
                    extractProperty.setValue(value);
                };
            }
            Minecraft.getInstance().setScreen((Screen)new PriorityScreen(title, priority, listener, parent, playerInventory));
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return SPRITE;
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        ArrayList<MutableComponent> subText = new ArrayList<MutableComponent>();
        boolean modifyingInsert = StoragePrioritySideButtonWidget.isModifyingInsert();
        boolean modifyingExtract = StoragePrioritySideButtonWidget.isModifyingExtract();
        if (Objects.equals(this.insertProperty.getValue(), this.extractProperty.getValue()) && !modifyingInsert && !modifyingExtract) {
            subText.add(IdentifierUtil.createTranslation("gui", "priority.insert_extract", this.insertProperty.getValue()).withStyle(ChatFormatting.GRAY));
        } else {
            subText.add(IdentifierUtil.createTranslation("gui", "priority.insert", this.insertProperty.getValue()).withStyle(modifyingInsert ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
            subText.add(IdentifierUtil.createTranslation("gui", "priority.extract", this.extractProperty.getValue()).withStyle(!modifyingInsert && modifyingExtract ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        }
        return subText;
    }

    private static boolean isModifyingInsert() {
        return Screen.hasControlDown();
    }

    private static boolean isModifyingExtract() {
        return Screen.hasAltDown();
    }

    @Override
    protected Component getHelpText() {
        return HELP;
    }
}

