/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class CompositeClientTooltipComponent
implements ClientTooltipComponent {
    private final List<ClientTooltipComponent> children;

    public CompositeClientTooltipComponent(List<ClientTooltipComponent> children) {
        this.children = children;
    }

    public int getHeight() {
        return this.children.stream().mapToInt(ClientTooltipComponent::getHeight).sum();
    }

    public int getWidth(Font font) {
        return this.children.stream().mapToInt(c -> c.getWidth(font)).max().orElse(0);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int yy = y;
        for (ClientTooltipComponent child : this.children) {
            child.renderImage(font, x, yy, graphics);
            yy += child.getHeight();
        }
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource buffer) {
        int yy = y;
        for (ClientTooltipComponent child : this.children) {
            child.renderText(font, x, yy, matrix, buffer);
            yy += child.getHeight();
        }
    }
}

