/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.LootFunctions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class EnergyLootItemFunction
implements LootItemFunction {
    public LootItemFunctionType<? extends EnergyLootItemFunction> getType() {
        return LootFunctions.INSTANCE.getEnergy();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParam(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TransferableBlockEntityEnergy) {
            TransferableBlockEntityEnergy transferableBlockEntityEnergy = (TransferableBlockEntityEnergy)blockEntity;
            long stored = transferableBlockEntityEnergy.getEnergyStorage().getStored();
            RefinedStorageApi.INSTANCE.getEnergyStorage(stack).ifPresent(energyStorage -> energyStorage.receive(stored, Action.EXECUTE));
        }
        return stack;
    }
}

