/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.direction;

import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.support.direction.HorizontalDirection;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class HorizontalDirectionType
implements DirectionType<HorizontalDirection> {
    public static final DirectionType<HorizontalDirection> INSTANCE = new HorizontalDirectionType();
    private static final EnumProperty<HorizontalDirection> PROPERTY = EnumProperty.create((String)"direction", HorizontalDirection.class);

    @Override
    public EnumProperty<HorizontalDirection> getProperty() {
        return PROPERTY;
    }

    @Override
    public HorizontalDirection getDefault() {
        return HorizontalDirection.NORTH;
    }

    @Override
    public Direction extractDirection(HorizontalDirection direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> Direction.NORTH;
            case HorizontalDirection.EAST -> Direction.EAST;
            case HorizontalDirection.SOUTH -> Direction.SOUTH;
            case HorizontalDirection.WEST -> Direction.WEST;
        };
    }

    @Override
    public HorizontalDirection getDirection(Direction clickedFace, Direction playerFacing, float playerPitch) {
        return switch (playerFacing) {
            case Direction.EAST -> HorizontalDirection.EAST;
            case Direction.SOUTH -> HorizontalDirection.SOUTH;
            case Direction.WEST -> HorizontalDirection.WEST;
            default -> HorizontalDirection.NORTH;
        };
    }

    @Override
    public HorizontalDirection rotate(HorizontalDirection direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> HorizontalDirection.EAST;
            case HorizontalDirection.EAST -> HorizontalDirection.SOUTH;
            case HorizontalDirection.SOUTH -> HorizontalDirection.WEST;
            case HorizontalDirection.WEST -> HorizontalDirection.NORTH;
        };
    }
}

