/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceInventoryDestination;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferDestination;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransferManager {
    private final Map<TransferDestination, List<TransferDestination>> destinationMap = new HashMap<TransferDestination, List<TransferDestination>>();
    private final AbstractContainerMenu containerMenu;
    private final Function<Container, TransferDestination> destinationFactory;

    public TransferManager(AbstractContainerMenu containerMenu, Function<Container, TransferDestination> destinationFactory) {
        this.containerMenu = containerMenu;
        this.destinationFactory = destinationFactory;
    }

    public void addTransfer(Container from, Container to) {
        this.addTransfer(this.destinationFactory.apply(from), this.destinationFactory.apply(to));
    }

    private void addTransfer(TransferDestination from, TransferDestination to) {
        List destinationList = this.destinationMap.computeIfAbsent(from, k -> new LinkedList());
        destinationList.add(to);
    }

    public void addFilterTransfer(Container from) {
        AbstractContainerMenu abstractContainerMenu = this.containerMenu;
        if (!(abstractContainerMenu instanceof AbstractResourceContainerMenu)) {
            throw new UnsupportedOperationException(this.containerMenu.getClass().toString());
        }
        AbstractResourceContainerMenu resourceContainer = (AbstractResourceContainerMenu)abstractContainerMenu;
        this.addTransfer(this.destinationFactory.apply(from), new ResourceInventoryDestination(resourceContainer));
    }

    public void addBiTransfer(Container from, Container to) {
        this.addTransfer(from, to);
        this.addTransfer(to, from);
    }

    public boolean transfer(int index) {
        Slot slot = this.containerMenu.getSlot(index);
        if (slot.getItem().isEmpty()) {
            return false;
        }
        TransferDestination key = this.destinationFactory.apply(slot.container);
        List<TransferDestination> destinations = this.destinationMap.get(key);
        return destinations != null && this.transfer(slot, destinations);
    }

    private boolean transfer(Slot slot, List<TransferDestination> destinations) {
        ItemStack initial = slot.getItem().copy();
        ItemStack remainder = this.doTransfer(initial, destinations);
        slot.set(remainder);
        slot.setChanged();
        return initial.getCount() != remainder.getCount();
    }

    private ItemStack doTransfer(ItemStack initial, List<TransferDestination> destinations) {
        TransferDestination destination;
        ItemStack destinationRemainder;
        ItemStack remainder = initial;
        Iterator<TransferDestination> iterator = destinations.iterator();
        while (iterator.hasNext() && (destinationRemainder = (destination = iterator.next()).transfer(remainder)) != null) {
            remainder = destinationRemainder;
            if (!remainder.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remainder;
    }

    public void clear() {
        this.destinationMap.clear();
    }
}

