/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.support.PlayerInventoryListener;
import com.refinedmods.refinedstorage.common.support.PlayerInventorySlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.FilterSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractBaseContainerMenu
extends AbstractContainerMenu {
    protected final TransferManager transferManager;
    @Nullable
    protected SlotReference disabledSlot;
    private final Map<PropertyType<?>, Property<?>> propertyMap = new HashMap();

    protected AbstractBaseContainerMenu(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
        this.transferManager = Platform.INSTANCE.createTransferManager(this);
    }

    public <T> boolean hasProperty(PropertyType<T> type) {
        return this.propertyMap.containsKey(type);
    }

    public <T> ClientProperty<T> getProperty(PropertyType<T> type) {
        return (ClientProperty)Objects.requireNonNull(this.propertyMap.get(type), "Property not found");
    }

    public void receivePropertyChangeFromClient(ResourceLocation id, int newValue) {
        for (Map.Entry<PropertyType<?>, Property<?>> entry : this.propertyMap.entrySet()) {
            PropertyType<?> type = entry.getKey();
            if (!type.id().equals((Object)id)) continue;
            Property<?> property = entry.getValue();
            ((ServerProperty)property).set(newValue);
        }
    }

    protected <T> void registerProperty(Property<T> property) {
        this.propertyMap.put(property.getType(), property);
        this.addDataSlot(property.getDataSlot());
    }

    protected void resetSlots() {
        this.slots.clear();
    }

    protected final void addPlayerInventory(Inventory inventory, int inventoryX, int inventoryY) {
        this.addPlayerInventory(inventory, inventoryX, inventoryY, null);
    }

    protected final void addPlayerInventory(Inventory inventory, int inventoryX, int inventoryY, @Nullable PlayerInventoryListener listener) {
        int x;
        int id = 9;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new PlayerInventorySlot((Container)inventory, id++, inventoryX + x * 18, inventoryY + y * 18, listener));
            }
        }
        id = 0;
        for (int i = 0; i < 9; ++i) {
            x = inventoryX + i * 18;
            int y = inventoryY + 4 + 54;
            boolean disabled = this.disabledSlot != null && this.disabledSlot.isDisabledSlot(id);
            Slot slot = disabled ? new DisabledSlot((Container)inventory, id, x, y) : new PlayerInventorySlot((Container)inventory, id, x, y, listener);
            this.addSlot(slot);
            ++id;
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        this.transferManager.transfer(index);
        return ItemStack.EMPTY;
    }

    public void clicked(int id, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = id >= 0 ? this.getSlot(id) : null;
        if (this.isSwappingDisabledSlotWithNumberKeys(dragType, clickType)) {
            return;
        }
        if (slot instanceof FilterSlot) {
            ItemStack carried = player.containerMenu.getCarried();
            if (carried.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else if (slot.mayPlace(carried)) {
                slot.set(carried.copy());
            }
            return;
        }
        if (slot instanceof DisabledSlot) {
            return;
        }
        super.clicked(id, dragType, clickType, player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot || slot instanceof DisabledSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    private boolean isSwappingDisabledSlotWithNumberKeys(int dragType, ClickType clickType) {
        return this.disabledSlot != null && clickType == ClickType.SWAP && this.disabledSlot.isDisabledSlot(dragType);
    }

    public void handleFilterSlotChange(int slotIndex, ItemStack stack) {
        FilterSlot filterSlot;
        if (slotIndex < 0 || slotIndex >= this.slots.size()) {
            return;
        }
        Object object = this.slots.get(slotIndex);
        if (object instanceof FilterSlot && (filterSlot = (FilterSlot)((Object)object)).mayPlace(stack)) {
            filterSlot.set(stack);
        }
    }
}

