/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;

public class ItemStorageMonitorInsertionStrategy
implements StorageMonitorInsertionStrategy {
    @Override
    public Optional<ItemStack> insert(ResourceKey configuredResource, ItemStack stack, Actor actor, Network network) {
        if (!(configuredResource instanceof ItemResource)) {
            return Optional.empty();
        }
        ItemResource configuredItemResource = (ItemResource)configuredResource;
        ItemResource resource = ItemResource.ofItemStack(stack);
        if (!configuredItemResource.equals(resource)) {
            return Optional.empty();
        }
        long inserted = network.getComponent(StorageNetworkComponent.class).insert(resource, stack.getCount(), Action.EXECUTE, actor);
        long remainder = (long)stack.getCount() - inserted;
        if (remainder > 0L) {
            return Optional.of(resource.toItemStack(remainder));
        }
        return Optional.of(ItemStack.EMPTY);
    }
}

