/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class AutocraftingStorageMonitorContainerMenu
extends AutocraftingPreviewContainerMenu
implements PreviewProvider {
    @Nullable
    private final StorageMonitorBlockEntity storageMonitor;

    public AutocraftingStorageMonitorContainerMenu(int syncId, PlatformResourceKey resource) {
        super(Menus.INSTANCE.getAutocraftingStorageMonitor(), syncId, AutocraftingStorageMonitorContainerMenu.getRequests(resource));
        this.storageMonitor = null;
    }

    AutocraftingStorageMonitorContainerMenu(int syncId, PlatformResourceKey resource, StorageMonitorBlockEntity storageMonitor) {
        super(Menus.INSTANCE.getAutocraftingStorageMonitor(), syncId, AutocraftingStorageMonitorContainerMenu.getRequests(resource));
        this.storageMonitor = storageMonitor;
    }

    private static List<AutocraftingRequest> getRequests(PlatformResourceKey resource) {
        return List.of(AutocraftingRequest.of(new ResourceAmount(resource, resource.getResourceType().normalizeAmount(1.0))));
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount) {
        return Objects.requireNonNull(this.storageMonitor).getPreview(resource, amount);
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource) {
        return Objects.requireNonNull(this.storageMonitor).getMaxAmount(resource);
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify) {
        return Objects.requireNonNull(this.storageMonitor).startTask(resource, amount, actor, notify);
    }
}

