/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storagedisk;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStorageDiskItem
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private static final Component CREATIVE_HELP = IdentifierUtil.createTranslation("item", "creative_storage_disk.help");
    private final ItemStorageVariant variant;
    private final Component helpText;

    public ItemStorageDiskItem(ItemStorageVariant variant) {
        super(new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = ItemStorageDiskItem.getHelpText(variant);
    }

    private static Component getHelpText(ItemStorageVariant variant) {
        return variant.getCapacity() == null ? CREATIVE_HELP : IdentifierUtil.createTranslation("item", "storage_disk.help", IdentifierUtil.format(variant.getCapacity()));
    }

    @Override
    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    @Override
    protected String formatAmount(long amount) {
        return IdentifierUtil.format(amount);
    }

    @Override
    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return StorageTypes.ITEM.create(this.variant.getCapacity(), storageRepository::markAsChanged);
    }

    @Override
    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Items.INSTANCE.getStorageHousing(), count);
    }

    @Override
    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        if (this.variant == ItemStorageVariant.CREATIVE) {
            return null;
        }
        return new ItemStack((ItemLike)Items.INSTANCE.getItemStoragePart(this.variant), count);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    @Override
    public StorageVariant getVariant() {
        return this.variant;
    }

    @Override
    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

