/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.AbstractProxyStorage;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageRepository;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.storage.StorageCodecs;
import java.util.Optional;

class PlatformStorage
extends AbstractProxyStorage
implements SerializableStorage,
TrackedStorage {
    private final StorageType type;
    private final TrackedStorageRepository trackingRepository;
    private final Runnable listener;

    PlatformStorage(Storage delegate, StorageType type, TrackedStorageRepository trackingRepository, Runnable listener) {
        super(delegate);
        this.type = type;
        this.trackingRepository = trackingRepository;
        this.listener = listener;
    }

    void load(StorageCodecs.StorageResource<? extends ResourceKey> storageResource) {
        ResourceKey resource = storageResource.resource();
        if (!this.type.isAllowed(resource)) {
            return;
        }
        super.insert(resource, storageResource.amount(), Action.EXECUTE, Actor.EMPTY);
        storageResource.changed().ifPresent(changed -> this.trackingRepository.update(resource, new PlayerActor(changed.changedBy()), changed.changedAt()));
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!this.type.isAllowed(resource)) {
            return 0L;
        }
        long extracted = super.extract(resource, amount, action, actor);
        if (extracted > 0L && action == Action.EXECUTE) {
            this.listener.run();
        }
        return extracted;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!this.type.isAllowed(resource)) {
            return 0L;
        }
        long inserted = super.insert(resource, amount, action, actor);
        if (inserted > 0L && action == Action.EXECUTE) {
            this.listener.run();
        }
        return inserted;
    }

    @Override
    public StorageType getType() {
        return this.type;
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        return this.trackingRepository.findTrackedResourceByActorType(resource, actorType);
    }
}

