/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FilterModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "filter_mode");
    private static final List<MutableComponent> SUBTEXT_BLOCK = List.of(IdentifierUtil.createTranslation("gui", "filter_mode.block").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_ALLOW = List.of(IdentifierUtil.createTranslation("gui", "filter_mode.allow").withStyle(ChatFormatting.GRAY));
    private static final Component FILTER_MODE_WARNING = IdentifierUtil.createTranslation("gui", "storage.filter_mode.empty_warning");
    private static final ResourceLocation ALLOW = IdentifierUtil.createIdentifier("widget/side_button/storage/filter_mode/allow");
    private static final ResourceLocation BLOCK = IdentifierUtil.createIdentifier("widget/side_button/storage/filter_mode/block");
    private final ClientProperty<FilterMode> property;
    private final Component helpAllow;
    private final Component helpBlock;

    public FilterModeSideButtonWidget(ClientProperty<FilterMode> property, Component helpAllow, Component helpBlock) {
        super(FilterModeSideButtonWidget.createPressAction(property));
        this.property = property;
        this.helpAllow = helpAllow;
        this.helpBlock = helpBlock;
    }

    public void setWarningVisible(boolean visible) {
        if (visible) {
            this.setWarning(FILTER_MODE_WARNING);
        } else {
            this.setWarning(null);
        }
    }

    private static Button.OnPress createPressAction(ClientProperty<FilterMode> property) {
        return btn -> property.setValue(FilterModeSideButtonWidget.toggle((FilterMode)((Object)((Object)property.getValue()))));
    }

    private static FilterMode toggle(FilterMode filterMode) {
        return filterMode == FilterMode.ALLOW ? FilterMode.BLOCK : FilterMode.ALLOW;
    }

    @Override
    protected ResourceLocation getSprite() {
        return this.property.getValue() == FilterMode.BLOCK ? BLOCK : ALLOW;
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return this.property.getValue() == FilterMode.BLOCK ? SUBTEXT_BLOCK : SUBTEXT_ALLOW;
    }

    @Override
    protected Component getHelpText() {
        return this.property.getValue() == FilterMode.BLOCK ? this.helpBlock : this.helpAllow;
    }
}

