/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.networking.RelayContainerMenu;
import com.refinedmods.refinedstorage.common.networking.RelayPassAutocraftingSideButtonWidget;
import com.refinedmods.refinedstorage.common.networking.RelayPassEnergySideButtonWidget;
import com.refinedmods.refinedstorage.common.networking.RelayPassSecuritySideButtonWidget;
import com.refinedmods.refinedstorage.common.networking.RelayPassStorageSideButtonWidget;
import com.refinedmods.refinedstorage.common.networking.RelayPassThroughSideButtonWidget;
import com.refinedmods.refinedstorage.common.networking.RelayPropertyTypes;
import com.refinedmods.refinedstorage.common.storage.AccessModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.storage.FilterModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.storage.StoragePropertyTypes;
import com.refinedmods.refinedstorage.common.support.AbstractFilterScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.FuzzyModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.StoragePrioritySideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class RelayScreen
extends AbstractFilterScreen<RelayContainerMenu>
implements RelayContainerMenu.PassThroughListener {
    private static final MutableComponent ALLOW_FILTER_MODE_HELP = IdentifierUtil.createTranslation("gui", "relay.filter_mode.allow.help");
    private static final MutableComponent BLOCK_FILTER_MODE_HELP = IdentifierUtil.createTranslation("gui", "relay.filter_mode.block.help");
    private final Inventory playerInventory;
    @Nullable
    private AbstractSideButtonWidget passEnergyButton;
    @Nullable
    private AbstractSideButtonWidget passSecurityButton;
    @Nullable
    private AbstractSideButtonWidget passStorageButton;
    @Nullable
    private AbstractSideButtonWidget passAutocraftingButton;
    @Nullable
    private AbstractSideButtonWidget filterModeButton;
    @Nullable
    private AbstractSideButtonWidget fuzzyModeButton;
    @Nullable
    private AbstractSideButtonWidget accessModeButton;
    @Nullable
    private AbstractSideButtonWidget priorityButton;

    public RelayScreen(RelayContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.playerInventory = playerInventory;
        menu.setPassThroughListener(this);
    }

    @Override
    protected boolean hasUpgrades() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RelayPassThroughSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(RelayPropertyTypes.PASS_THROUGH)));
        boolean visible = !((RelayContainerMenu)this.getMenu()).isPassThrough();
        this.addPassButtons(visible);
        this.addFilterButtons(visible && (((RelayContainerMenu)this.getMenu()).isPassStorage() || ((RelayContainerMenu)this.getMenu()).isPassAutocrafting()));
        this.addStorageButtons(visible && ((RelayContainerMenu)this.getMenu()).isPassStorage());
    }

    private void addPassButtons(boolean visible) {
        this.passEnergyButton = new RelayPassEnergySideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(RelayPropertyTypes.PASS_ENERGY));
        this.passEnergyButton.visible = visible;
        this.addSideButton(this.passEnergyButton);
        this.passSecurityButton = new RelayPassSecuritySideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(RelayPropertyTypes.PASS_SECURITY));
        this.passSecurityButton.visible = visible;
        this.addSideButton(this.passSecurityButton);
        this.passAutocraftingButton = new RelayPassAutocraftingSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(RelayPropertyTypes.PASS_AUTOCRAFTING));
        this.passAutocraftingButton.visible = visible;
        this.addSideButton(this.passAutocraftingButton);
        this.passStorageButton = new RelayPassStorageSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(RelayPropertyTypes.PASS_STORAGE));
        this.passStorageButton.visible = visible;
        this.addSideButton(this.passStorageButton);
    }

    private void addFilterButtons(boolean visible) {
        this.filterModeButton = new FilterModeSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(PropertyTypes.FILTER_MODE), (Component)ALLOW_FILTER_MODE_HELP, (Component)BLOCK_FILTER_MODE_HELP);
        this.filterModeButton.visible = visible;
        this.addSideButton(this.filterModeButton);
        this.fuzzyModeButton = new FuzzyModeSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(PropertyTypes.FUZZY_MODE), () -> FuzzyModeSideButtonWidget.Type.STORAGE);
        this.fuzzyModeButton.visible = visible;
        this.addSideButton(this.fuzzyModeButton);
    }

    private void addStorageButtons(boolean visible) {
        this.accessModeButton = new AccessModeSideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.ACCESS_MODE));
        this.accessModeButton.visible = visible;
        this.addSideButton(this.accessModeButton);
        this.priorityButton = new StoragePrioritySideButtonWidget(((RelayContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.INSERT_PRIORITY), ((RelayContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.EXTRACT_PRIORITY), this.playerInventory, (Screen)this);
        this.priorityButton.visible = visible;
        this.addSideButton(this.priorityButton);
    }

    @Override
    public void passThroughChanged(boolean passThrough, boolean passStorage, boolean passAutocrafting) {
        this.updatePassButtons(passThrough);
        this.updateFilterButtons(!passThrough && (passStorage || passAutocrafting));
        this.updateStorageButtons(!passThrough && passStorage);
    }

    private void updatePassButtons(boolean passThrough) {
        if (this.passEnergyButton != null) {
            boolean bl = this.passEnergyButton.visible = !passThrough;
        }
        if (this.passSecurityButton != null) {
            boolean bl = this.passSecurityButton.visible = !passThrough;
        }
        if (this.passStorageButton != null) {
            boolean bl = this.passStorageButton.visible = !passThrough;
        }
        if (this.passAutocraftingButton != null) {
            this.passAutocraftingButton.visible = !passThrough;
        }
    }

    private void updateFilterButtons(boolean visible) {
        if (this.filterModeButton != null) {
            this.filterModeButton.visible = visible;
        }
        if (this.fuzzyModeButton != null) {
            this.fuzzyModeButton.visible = visible;
        }
    }

    private void updateStorageButtons(boolean visible) {
        if (this.accessModeButton != null) {
            this.accessModeButton.visible = visible;
        }
        if (this.priorityButton != null) {
            this.priorityButton.visible = visible;
        }
    }
}

