/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.networking.RelayBlockEntity;
import com.refinedmods.refinedstorage.common.networking.RelayPropertyTypes;
import com.refinedmods.refinedstorage.common.storage.StoragePropertyTypes;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSimpleFilterContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class RelayContainerMenu
extends AbstractSimpleFilterContainerMenu<RelayBlockEntity> {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation("gui", "relay.filter_help");
    @Nullable
    private PassThroughListener passThroughListener;

    public RelayContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getRelay(), syncId, playerInventory.player, resourceContainerData, null, (Component)FILTER_HELP);
    }

    RelayContainerMenu(int syncId, Player player, RelayBlockEntity relay, ResourceContainer resourceContainer) {
        super(Menus.INSTANCE.getRelay(), syncId, player, resourceContainer, null, relay, (Component)FILTER_HELP);
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.registerProperty(new ClientProperty<Boolean>(RelayPropertyTypes.PASS_THROUGH, Boolean.valueOf(true)){

            @Override
            protected void onChangedOnClient(Boolean newValue) {
                super.onChangedOnClient(newValue);
                if (RelayContainerMenu.this.passThroughListener != null) {
                    RelayContainerMenu.this.passThroughListener.passThroughChanged(Boolean.TRUE.equals(newValue), Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_STORAGE).getValue()), Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_AUTOCRAFTING).getValue()));
                }
            }
        });
        this.registerProperty(new ClientProperty<Boolean>(RelayPropertyTypes.PASS_ENERGY, false));
        this.registerProperty(new ClientProperty<Boolean>(RelayPropertyTypes.PASS_STORAGE, Boolean.valueOf(false)){

            @Override
            protected void onChangedOnClient(Boolean newValue) {
                super.onChangedOnClient(newValue);
                if (RelayContainerMenu.this.passThroughListener != null) {
                    RelayContainerMenu.this.passThroughListener.passThroughChanged(Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_THROUGH).getValue()), Boolean.TRUE.equals(newValue), Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_AUTOCRAFTING).getValue()));
                }
            }
        });
        this.registerProperty(new ClientProperty<Boolean>(RelayPropertyTypes.PASS_SECURITY, false));
        this.registerProperty(new ClientProperty<Boolean>(RelayPropertyTypes.PASS_AUTOCRAFTING, Boolean.valueOf(false)){

            @Override
            protected void onChangedOnClient(Boolean newValue) {
                super.onChangedOnClient(newValue);
                if (RelayContainerMenu.this.passThroughListener != null) {
                    RelayContainerMenu.this.passThroughListener.passThroughChanged(Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_THROUGH).getValue()), Boolean.TRUE.equals(RelayContainerMenu.this.getProperty(RelayPropertyTypes.PASS_STORAGE).getValue()), Boolean.TRUE.equals(newValue));
                }
            }
        });
        this.registerProperty(new ClientProperty<FilterMode>(PropertyTypes.FILTER_MODE, FilterMode.BLOCK));
        this.registerProperty(new ClientProperty<AccessMode>(StoragePropertyTypes.ACCESS_MODE, AccessMode.INSERT_EXTRACT));
        this.registerProperty(new ClientProperty<Integer>(StoragePropertyTypes.INSERT_PRIORITY, 0));
        this.registerProperty(new ClientProperty<Integer>(StoragePropertyTypes.EXTRACT_PRIORITY, 0));
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
    }

    @Override
    protected void registerServerProperties(RelayBlockEntity blockEntity) {
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.registerProperty(new ServerProperty<Boolean>(RelayPropertyTypes.PASS_THROUGH, blockEntity::isPassThrough, blockEntity::setPassThrough));
        this.registerProperty(new ServerProperty<Boolean>(RelayPropertyTypes.PASS_ENERGY, blockEntity::isPassEnergy, blockEntity::setPassEnergy));
        this.registerProperty(new ServerProperty<Boolean>(RelayPropertyTypes.PASS_STORAGE, blockEntity::isPassStorage, blockEntity::setPassStorage));
        this.registerProperty(new ServerProperty<Boolean>(RelayPropertyTypes.PASS_SECURITY, blockEntity::isPassSecurity, blockEntity::setPassSecurity));
        this.registerProperty(new ServerProperty<Boolean>(RelayPropertyTypes.PASS_AUTOCRAFTING, blockEntity::isPassAutocrafting, blockEntity::setPassAutocrafting));
        this.registerProperty(new ServerProperty<FilterMode>(PropertyTypes.FILTER_MODE, blockEntity::getFilterMode, blockEntity::setFilterMode));
        this.registerProperty(new ServerProperty<AccessMode>(StoragePropertyTypes.ACCESS_MODE, blockEntity::getAccessMode, blockEntity::setAccessMode));
        this.registerProperty(new ServerProperty<Integer>(StoragePropertyTypes.INSERT_PRIORITY, blockEntity::getInsertPriority, blockEntity::setInsertPriority));
        this.registerProperty(new ServerProperty<Integer>(StoragePropertyTypes.EXTRACT_PRIORITY, blockEntity::getExtractPriority, blockEntity::setExtractPriority));
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
    }

    boolean isPassThrough() {
        return Boolean.TRUE.equals(this.getProperty(RelayPropertyTypes.PASS_THROUGH).getValue());
    }

    boolean isPassStorage() {
        return Boolean.TRUE.equals(this.getProperty(RelayPropertyTypes.PASS_STORAGE).getValue());
    }

    boolean isPassAutocrafting() {
        return Boolean.TRUE.equals(this.getProperty(RelayPropertyTypes.PASS_AUTOCRAFTING).getValue());
    }

    void setPassThroughListener(PassThroughListener passThroughListener) {
        this.passThroughListener = passThroughListener;
    }

    static interface PassThroughListener {
        public void passThroughChanged(boolean var1, boolean var2, boolean var3);
    }
}

