/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class GridResourceRepositoryMapper
implements ResourceRepositoryMapper<GridResource> {
    private final Map<Class<? extends ResourceKey>, ResourceRepositoryMapper<GridResource>> strategies = new HashMap<Class<? extends ResourceKey>, ResourceRepositoryMapper<GridResource>>();
    @Nullable
    private ResourceRepositoryMapper<GridResource> itemFactory;
    @Nullable
    private ResourceRepositoryMapper<GridResource> fluidFactory;

    public void addFactory(Class<? extends ResourceKey> resourceClass, ResourceRepositoryMapper<GridResource> factory) {
        if (resourceClass == ItemResource.class) {
            this.itemFactory = factory;
        } else if (resourceClass == FluidResource.class) {
            this.fluidFactory = factory;
        } else {
            this.strategies.put(resourceClass, factory);
        }
    }

    @Override
    public GridResource apply(ResourceKey resource) {
        Class<?> resourceClass = resource.getClass();
        if (resourceClass == ItemResource.class && this.itemFactory != null) {
            return (GridResource)this.itemFactory.apply((GridResource)((Object)resource));
        }
        if (resourceClass == FluidResource.class && this.fluidFactory != null) {
            return (GridResource)this.fluidFactory.apply((GridResource)((Object)resource));
        }
        ResourceRepositoryMapper<GridResource> factory = Objects.requireNonNull(this.strategies.get(resourceClass), "No factory for " + String.valueOf(resourceClass));
        return (GridResource)factory.apply((GridResource)((Object)resource));
    }
}

