/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.screen.AutocraftableClientTooltipComponent;
import com.refinedmods.refinedstorage.common.grid.screen.GridSearchBoxWidget;
import com.refinedmods.refinedstorage.common.grid.screen.LastModified;
import com.refinedmods.refinedstorage.common.grid.screen.ResourceTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SortingDirectionSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SortingTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SynchronizationModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.ViewTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighterColors;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGridScreen<T extends AbstractGridContainerMenu>
extends AbstractStretchingScreen<T> {
    protected static final int CLEAR_BUTTON_SIZE = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGridScreen.class);
    private static final ResourceLocation ROW_SPRITE = IdentifierUtil.createIdentifier("grid/row");
    private static final int MODIFIED_JUST_NOW_MAX_SECONDS = 10;
    private static final int COLUMNS = 9;
    private static final int DISABLED_SLOT_COLOR = -10790053;
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final Component SEARCH_HELP = IdentifierUtil.createTranslation("gui", "grid.search_help").append("\n").append((Component)IdentifierUtil.createTranslation("gui", "grid.search_help.mod_search").withStyle(ChatFormatting.GRAY)).append("\n").append((Component)IdentifierUtil.createTranslation("gui", "grid.search_help.tag_search").withStyle(ChatFormatting.GRAY)).append("\n").append((Component)IdentifierUtil.createTranslation("gui", "grid.search_help.tooltip_search").withStyle(ChatFormatting.GRAY));
    protected final int bottomHeight;
    @Nullable
    GridSearchBoxWidget searchField;
    private int totalRows;
    private int currentGridSlotIndex;

    protected AbstractGridScreen(T menu, Inventory playerInventory, Component title, int bottomHeight) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.bottomHeight = bottomHeight;
    }

    @Override
    protected void init(int rows) {
        LOGGER.debug("Initializing grid screen - this shouldn't happen too much!");
        if (this.searchField == null) {
            this.searchField = new GridSearchBoxWidget(this.font, this.leftPos + 94 + 1, this.topPos + 6 + 1, 67, new SyntaxHighlighter(SyntaxHighlighterColors.DEFAULT_COLORS), new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.setX(this.leftPos + 94 + 1);
            this.searchField.setY(this.topPos + 6 + 1);
        }
        ((AbstractGridContainerMenu)this.getMenu()).setSearchBox(this.searchField);
        ((AbstractGridContainerMenu)this.getMenu()).getRepository().setListener(this::updateScrollbar);
        this.updateScrollbar();
        this.addWidget((GuiEventListener)this.searchField);
        if (((AbstractGridContainerMenu)this.getMenu()).hasProperty(PropertyTypes.REDSTONE_MODE)) {
            this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractGridContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        }
        this.addSideButton(new ViewTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new ResourceTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new SortingDirectionSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new SortingTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new AutoSelectedSideButtonWidget(this.searchField));
        this.addRenderableWidget((GuiEventListener)new SearchIconWidget(this.leftPos + 79, this.topPos + 5, () -> SEARCH_HELP, this.searchField));
        boolean onlyHasNoopSynchronizer = RefinedStorageApi.INSTANCE.getGridSynchronizerRegistry().getAll().stream().allMatch(synchronizer -> synchronizer == NoopGridSynchronizer.INSTANCE);
        if (!onlyHasNoopSynchronizer) {
            this.addSideButton(new SynchronizationModeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
            this.searchField.addListener(this::trySynchronizeFromGrid);
        }
    }

    private void trySynchronizeFromGrid(String text) {
        ((AbstractGridContainerMenu)this.getMenu()).getSynchronizer().synchronizeFromGrid(text);
    }

    protected void containerTick() {
        super.containerTick();
        this.trySynchronizeToGrid();
    }

    private void trySynchronizeToGrid() {
        if (this.searchField == null) {
            return;
        }
        String text = ((AbstractGridContainerMenu)this.getMenu()).getSynchronizer().getTextToSynchronizeToGrid();
        if (text == null || this.searchField.getValue().equals(text)) {
            return;
        }
        this.searchField.setValue(text);
    }

    private void updateScrollbar() {
        this.totalRows = (int)Math.ceil((float)((AbstractGridContainerMenu)this.getMenu()).getRepository().getViewList().size() / 9.0f);
        this.updateScrollbar(this.totalRows);
    }

    private boolean isOverStorageArea(int mouseX, int mouseY) {
        int relativeMouseX = mouseX - this.leftPos;
        int relativeMouseY = mouseY - this.topPos;
        return relativeMouseX >= 7 && relativeMouseX <= 168 && this.isInStretchedArea(relativeMouseY);
    }

    @Override
    protected void renderStretchingBackground(GuiGraphics graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.blit(this.getTexture(), x, y + 18 * row, 0, textureY, this.imageWidth, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return this.bottomHeight;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected void renderRows(GuiGraphics graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        this.currentGridSlotIndex = -1;
        for (int row = 0; row < Math.max(this.totalRows, rows); ++row) {
            boolean isOutOfFrame;
            int rowX = x + 7;
            int rowY = y + topHeight + row * 18 - this.getScrollbarOffset();
            boolean bl = isOutOfFrame = rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
            if (isOutOfFrame) continue;
            this.renderRow(graphics, mouseX, mouseY, rowX, rowY, row);
        }
    }

    private void renderRow(GuiGraphics graphics, int mouseX, int mouseY, int rowX, int rowY, int row) {
        graphics.blitSprite(ROW_SPRITE, rowX, rowY, 162, 18);
        for (int column = 0; column < 9; ++column) {
            this.renderCell(graphics, mouseX, mouseY, rowX, rowY, row * 9 + column, column);
        }
    }

    private void renderCell(GuiGraphics graphics, int mouseX, int mouseY, int rowX, int rowY, int idx, int column) {
        ResourceRepository<GridResource> repository = ((AbstractGridContainerMenu)this.getMenu()).getRepository();
        int slotX = rowX + 1 + column * 18;
        int slotY = rowY + 1;
        if (!((AbstractGridContainerMenu)this.getMenu()).isActive()) {
            this.renderDisabledSlot(graphics, slotX, slotY);
        } else {
            this.renderSlot(graphics, mouseX, mouseY, idx, repository, slotX, slotY);
        }
    }

    @Override
    protected List<ClientTooltipComponent> getResourceSlotTooltip(ResourceKey resource, ResourceSlot slot) {
        List<ClientTooltipComponent> tooltip = super.getResourceSlotTooltip(resource, slot);
        AutocraftableResourceHint autocraftableHint = ((AbstractGridContainerMenu)this.getMenu()).getAutocraftableResourceHint(slot);
        if (autocraftableHint != null) {
            tooltip.add(AutocraftableClientTooltipComponent.autocraftable(autocraftableHint));
        }
        return tooltip;
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        this.tryRenderAutocraftableResourceHintBackground(guiGraphics, slot);
        super.renderSlot(guiGraphics, slot);
    }

    private void renderSlot(GuiGraphics graphics, int mouseX, int mouseY, int idx, ResourceRepository<GridResource> repository, int slotX, int slotY) {
        boolean inBounds = mouseX >= slotX && mouseY >= slotY && mouseX <= slotX + 16 && mouseY <= slotY + 16;
        GridResource resource = null;
        if (idx < repository.getViewList().size()) {
            resource = repository.getViewList().get(idx);
            this.renderResourceWithAmount(graphics, slotX, slotY, resource);
        }
        if (inBounds && this.isOverStorageArea(mouseX, mouseY)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slotX, (int)slotY, (int)0);
            if (resource != null) {
                this.currentGridSlotIndex = idx;
            }
        }
    }

    private void tryRenderAutocraftableResourceHintBackground(GuiGraphics graphics, Slot slot) {
        if (!slot.isHighlightable() || !slot.isActive()) {
            return;
        }
        AutocraftableResourceHint hint = ((AbstractGridContainerMenu)this.getMenu()).getAutocraftableResourceHint(slot);
        if (hint != null) {
            AbstractGridScreen.renderSlotBackground(graphics, slot.x, slot.y, ((AbstractGridContainerMenu)this.getMenu()).isLargeSlot(slot), hint.getColor());
        }
    }

    private void renderResourceWithAmount(GuiGraphics graphics, int slotX, int slotY, GridResource resource) {
        if (resource.isAutocraftable(((AbstractGridContainerMenu)this.getMenu()).getRepository())) {
            AbstractGridScreen.renderSlotBackground(graphics, slotX, slotY, false, AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
        } else if (resource.getAmount(((AbstractGridContainerMenu)this.getMenu()).getRepository()) == 0L) {
            AbstractGridScreen.renderSlotBackground(graphics, slotX, slotY, false, 0x66FF0000);
        }
        resource.render(graphics, slotX, slotY);
        this.renderAmount(graphics, slotX, slotY, resource);
    }

    public static void renderSlotBackground(GuiGraphics graphics, int slotX, int slotY, boolean large, int color) {
        int offset = large ? 4 : 0;
        graphics.fill(slotX - offset, slotY - offset, slotX + 16 + offset, slotY + 16 + offset, color);
    }

    private void renderAmount(GuiGraphics graphics, int slotX, int slotY, GridResource resource) {
        long amount = resource.getAmount(((AbstractGridContainerMenu)this.getMenu()).getRepository());
        String text = this.getAmountText(resource, amount);
        int color = this.getAmountColor(resource, amount);
        boolean large = this.minecraft != null && this.minecraft.isEnforceUnicode() || Platform.INSTANCE.getConfig().getGrid().isLargeFont();
        ResourceSlotRendering.renderAmount(graphics, slotX, slotY, text, color, large);
    }

    private int getAmountColor(GridResource resource, long amount) {
        if (amount == 0L) {
            if (resource.isAutocraftable(((AbstractGridContainerMenu)this.getMenu()).getRepository())) {
                return 0xFFFFFF;
            }
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    private String getAmountText(GridResource resource, long amount) {
        if (amount == 0L && resource.isAutocraftable(((AbstractGridContainerMenu)this.getMenu()).getRepository())) {
            return I18n.get((String)IdentifierUtil.createTranslationKey("gui", "grid.craft"), (Object[])new Object[0]);
        }
        return resource.getDisplayedAmount(((AbstractGridContainerMenu)this.getMenu()).getRepository());
    }

    private void renderDisabledSlot(GuiGraphics graphics, int slotX, int slotY) {
        graphics.fill(RenderType.guiOverlay(), slotX, slotY, slotX + 16, slotY + 16, -10790053);
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (this.isOverStorageArea(x, y)) {
            this.renderOverStorageAreaTooltip(graphics, x, y);
            return;
        }
        if (((AbstractGridContainerMenu)this.getMenu()).getCarried().isEmpty() && this.tryRenderAutocraftableResourceHintTooltip(graphics, x, y)) {
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    private boolean tryRenderAutocraftableResourceHintTooltip(GuiGraphics graphics, int x, int y) {
        if (this.hoveredSlot == null || !this.hoveredSlot.hasItem()) {
            return false;
        }
        AutocraftableResourceHint hint = ((AbstractGridContainerMenu)this.getMenu()).getAutocraftableResourceHint(this.hoveredSlot);
        if (hint == null) {
            return false;
        }
        ItemStack stack = this.hoveredSlot.getItem();
        List lines = this.getTooltipFromContainerItem(stack);
        List<ClientTooltipComponent> processedLines = Platform.INSTANCE.processTooltipComponents(stack, graphics, x, stack.getTooltipImage(), lines);
        processedLines.add(AutocraftableClientTooltipComponent.autocraftable(hint));
        Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
        return true;
    }

    private void renderOverStorageAreaTooltip(GuiGraphics graphics, int x, int y) {
        GridResource gridResource = this.getCurrentGridResource();
        if (gridResource != null) {
            this.renderHoveredResourceTooltip(graphics, x, y, gridResource);
            return;
        }
        ItemStack carried = ((AbstractGridContainerMenu)this.getMenu()).getCarried();
        if (carried.isEmpty()) {
            return;
        }
        List<ClientTooltipComponent> hints = RefinedStorageClientApi.INSTANCE.getGridInsertionHints().getHints(carried);
        Platform.INSTANCE.renderTooltip(graphics, hints, x, y);
    }

    private void renderHoveredResourceTooltip(GuiGraphics graphics, int mouseX, int mouseY, GridResource resource) {
        ItemStack itemStack;
        if (resource instanceof ItemGridResource) {
            ItemGridResource itemResource = (ItemGridResource)resource;
            itemStack = itemResource.getItemStack();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack stackContext = itemStack;
        List<Component> lines = resource.getTooltip();
        List<ClientTooltipComponent> processedLines = Platform.INSTANCE.processTooltipComponents(stackContext, graphics, mouseX, resource.getTooltipImage(), lines);
        long amount = resource.getAmount(((AbstractGridContainerMenu)this.getMenu()).getRepository());
        if (amount > 0L && Platform.INSTANCE.getConfig().getGrid().isDetailedTooltip()) {
            this.addDetailedTooltip(resource, processedLines);
        }
        if (resource.isAutocraftable(((AbstractGridContainerMenu)this.getMenu()).getRepository())) {
            processedLines.add(amount == 0L ? AutocraftableClientTooltipComponent.empty() : AutocraftableClientTooltipComponent.existing());
        }
        if (amount > 0L) {
            processedLines.addAll(resource.getExtractionHints(((AbstractGridContainerMenu)this.getMenu()).getCarried(), ((AbstractGridContainerMenu)this.getMenu()).getRepository()));
        }
        Platform.INSTANCE.renderTooltip(graphics, processedLines, mouseX, mouseY);
    }

    private void addDetailedTooltip(GridResource resource, List<ClientTooltipComponent> lines) {
        String amountInTooltip = resource.getAmountInTooltip(((AbstractGridContainerMenu)this.getMenu()).getRepository());
        lines.add(new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslation("misc", "total", amountInTooltip).withStyle(ChatFormatting.GRAY)));
        TrackedResource trackedResource = resource.getTrackedResource(((AbstractGridContainerMenu)this.getMenu())::getTrackedResource);
        if (trackedResource != null) {
            lines.add(new SmallTextClientTooltipComponent((Component)this.getLastModifiedText(trackedResource).withStyle(ChatFormatting.GRAY)));
        }
    }

    private MutableComponent getLastModifiedText(TrackedResource trackedResource) {
        boolean plural;
        LastModified lastModified = LastModified.calculate(trackedResource.getTime(), System.currentTimeMillis());
        if (this.isModifiedJustNow(lastModified)) {
            return IdentifierUtil.createTranslation("misc", "last_modified.just_now", trackedResource.getSourceName());
        }
        Object translationKey = lastModified.type().toString().toLowerCase();
        boolean bl = plural = lastModified.amount() != 1L;
        if (plural) {
            translationKey = (String)translationKey + "s";
        }
        return IdentifierUtil.createTranslation("misc", "last_modified." + (String)translationKey, lastModified.amount(), trackedResource.getSourceName());
    }

    private boolean isModifiedJustNow(LastModified lastModified) {
        return lastModified.type() == LastModified.Type.SECOND && lastModified.amount() <= 10L;
    }

    @API(status=API.Status.INTERNAL)
    @Nullable
    public GridResource getCurrentGridResource() {
        if (this.currentGridSlotIndex < 0) {
            return null;
        }
        List<GridResource> viewList = ((AbstractGridContainerMenu)this.menu).getRepository().getViewList();
        if (this.currentGridSlotIndex >= viewList.size()) {
            return null;
        }
        return viewList.get(this.currentGridSlotIndex);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.render(graphics, 0, 0, 0.0f);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        ItemStack carriedStack = ((AbstractGridContainerMenu)this.getMenu()).getCarried();
        GridResource resource = this.getCurrentGridResource();
        if (this.canExtract(resource, carriedStack)) {
            this.mouseClickedInGrid(clickedButton, resource);
            return true;
        }
        if (this.canInsert((int)mouseX, (int)mouseY, clickedButton, carriedStack)) {
            this.mouseClickedInGrid(clickedButton);
            return true;
        }
        if (resource != null && resource.isAutocraftable(((AbstractGridContainerMenu)this.getMenu()).getRepository()) && this.tryStartAutocrafting(resource)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    private boolean canExtract(@Nullable GridResource resource, ItemStack carriedStack) {
        return resource != null && resource.canExtract(carriedStack, ((AbstractGridContainerMenu)this.getMenu()).getRepository()) && !AbstractGridScreen.hasControlDown();
    }

    private boolean canInsert(int mouseX, int mouseY, int clickedButton, ItemStack carriedStack) {
        return this.isOverStorageArea(mouseX, mouseY) && !carriedStack.isEmpty() && (clickedButton == 0 || clickedButton == 1);
    }

    private boolean tryStartAutocrafting(GridResource resource) {
        ResourceAmount request = resource.getAutocraftingRequest();
        if (request == null) {
            return false;
        }
        RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(List.of(request), (Screen)this);
        return true;
    }

    private void mouseClickedInGrid(int clickedButton) {
        GridInsertMode mode = clickedButton == 1 ? GridInsertMode.SINGLE_RESOURCE : GridInsertMode.ENTIRE_RESOURCE;
        boolean tryAlternatives = clickedButton == 1;
        ((AbstractGridContainerMenu)this.getMenu()).onInsert(mode, tryAlternatives);
    }

    protected void mouseClickedInGrid(int clickedButton, GridResource resource) {
        resource.onExtract(AbstractGridScreen.getExtractMode(clickedButton), AbstractGridScreen.shouldExtractToCursor(), (GridExtractionStrategy)this.getMenu());
    }

    private static GridExtractMode getExtractMode(int clickedButton) {
        if (clickedButton == 1) {
            return GridExtractMode.HALF_RESOURCE;
        }
        return GridExtractMode.ENTIRE_RESOURCE;
    }

    private static boolean shouldExtractToCursor() {
        return !Screen.hasShiftDown();
    }

    @Override
    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean up;
        boolean bl = up = delta > 0.0;
        if (this.isOverStorageArea((int)x, (int)y)) {
            GridResource resource = this.getCurrentGridResource();
            if (resource != null) {
                this.mouseScrolledInGrid(up, resource);
            }
        } else if (this.hoveredSlot != null && this.hoveredSlot.hasItem() && !(this.hoveredSlot instanceof DisabledSlot)) {
            this.mouseScrolledInInventory(up, this.hoveredSlot);
        }
        return super.mouseScrolled(x, y, z, delta);
    }

    private void mouseScrolledInInventory(boolean up, Slot slot) {
        ((AbstractGridContainerMenu)this.getMenu()).getRepository().setPreventSorting(true);
        int slotIndex = slot.getContainerSlot();
        this.mouseScrolledInInventory(up, slot.getItem(), slotIndex);
    }

    private void mouseScrolledInInventory(boolean up, ItemStack stack, int slotIndex) {
        GridScrollMode scrollMode = AbstractGridScreen.getScrollModeWhenScrollingOnInventoryArea(up);
        if (scrollMode == null) {
            return;
        }
        ((AbstractGridContainerMenu)this.getMenu()).onScroll(ItemResource.ofItemStack(stack), scrollMode, slotIndex);
    }

    private void mouseScrolledInGrid(boolean up, GridResource resource) {
        ((AbstractGridContainerMenu)this.getMenu()).getRepository().setPreventSorting(true);
        GridScrollMode scrollMode = AbstractGridScreen.getScrollModeWhenScrollingOnGridArea(up);
        if (scrollMode == null) {
            return;
        }
        resource.onScroll(scrollMode, (GridScrollingStrategy)this.getMenu());
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnInventoryArea(boolean up) {
        if (Screen.hasShiftDown()) {
            return up ? GridScrollMode.INVENTORY_TO_GRID : GridScrollMode.GRID_TO_INVENTORY;
        }
        return null;
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnGridArea(boolean up) {
        boolean shift = Screen.hasShiftDown();
        boolean ctrl = Screen.hasControlDown();
        if (shift && ctrl) {
            return null;
        }
        return AbstractGridScreen.getScrollModeWhenScrollingOnGridArea(up, shift, ctrl);
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnGridArea(boolean up, boolean shift, boolean ctrl) {
        if (up) {
            if (shift) {
                return GridScrollMode.INVENTORY_TO_GRID;
            }
        } else {
            if (shift) {
                return GridScrollMode.GRID_TO_INVENTORY;
            }
            if (ctrl) {
                return GridScrollMode.GRID_TO_CURSOR;
            }
        }
        return null;
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (Screen.hasShiftDown() && Platform.INSTANCE.getConfig().getGrid().isPreventSortingWhileShiftIsDown()) {
            ((AbstractGridContainerMenu)this.getMenu()).getRepository().setPreventSorting(true);
        }
        if (this.searchField != null && this.searchField.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean keyReleased(int key, int scanCode, int modifiers) {
        if (((AbstractGridContainerMenu)this.getMenu()).getRepository().setPreventSorting(false)) {
            ((AbstractGridContainerMenu)this.getMenu()).getRepository().sort();
        }
        return super.keyReleased(key, scanCode, modifiers);
    }
}

