/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepositoryImpl;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryBuilder;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryBuilderImpl;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.api.resource.repository.SortingDirection;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.GridSynchronizer;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.registry.PlatformRegistry;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.GridSearchBox;
import com.refinedmods.refinedstorage.common.grid.GridSortingTypes;
import com.refinedmods.refinedstorage.common.grid.GridViewType;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.query.GridQueryParser;
import com.refinedmods.refinedstorage.common.grid.query.GridQueryParserException;
import com.refinedmods.refinedstorage.common.grid.strategy.ClientGridExtractionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.ClientGridInsertionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.ClientGridScrollingStrategy;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMappings;
import com.refinedmods.refinedstorage.query.parser.ParserOperatorMappings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGridContainerMenu
extends AbstractResourceContainerMenu
implements GridWatcher,
GridInsertionStrategy,
GridExtractionStrategy,
GridScrollingStrategy,
ScreenSizeListener,
PreviewProvider,
GridSortingTypes.TrackedResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGridContainerMenu.class);
    private static final GridQueryParser QUERY_PARSER = new GridQueryParser(LexerTokenMappings.DEFAULT_MAPPINGS, ParserOperatorMappings.DEFAULT_MAPPINGS);
    private static String lastSearchQuery = "";
    protected final Inventory playerInventory;
    private final ResourceRepository<GridResource> repository;
    private final PatternRepository playerInventoryPatterns = new PatternRepositoryImpl();
    private final Map<ResourceKey, TrackedResource> trackedResources = new HashMap<ResourceKey, TrackedResource>();
    @Nullable
    private Grid grid;
    @Nullable
    private GridInsertionStrategy insertionStrategy;
    @Nullable
    private GridExtractionStrategy extractionStrategy;
    @Nullable
    private GridScrollingStrategy scrollingStrategy;
    private GridSynchronizer synchronizer;
    @Nullable
    private ResourceType resourceTypeFilter;
    private boolean active;

    protected AbstractGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, GridData gridData) {
        super(menuType, syncId);
        this.playerInventory = playerInventory;
        this.active = gridData.active();
        ResourceRepositoryBuilder<GridResource> repositoryBuilder = AbstractGridContainerMenu.createRepositoryBuilder(this);
        gridData.resources().forEach(resource -> repositoryBuilder.addResource(resource.resourceAmount().resource(), resource.resourceAmount().amount()));
        gridData.autocraftableResources().forEach(repositoryBuilder::addStickyResource);
        this.repository = repositoryBuilder.build();
        this.repository.setSort(Platform.INSTANCE.getConfig().getGrid().getSortingType().apply(this).apply(this.repository), Platform.INSTANCE.getConfig().getGrid().getSortingDirection());
        this.repository.setFilterAndSort(this.createBaseFilter());
        this.synchronizer = this.loadSynchronizer();
        this.resourceTypeFilter = this.loadResourceType();
        this.insertionStrategy = new ClientGridInsertionStrategy();
        this.extractionStrategy = new ClientGridExtractionStrategy();
        this.scrollingStrategy = new ClientGridScrollingStrategy();
    }

    protected AbstractGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, Grid grid) {
        super(menuType, syncId, playerInventory.player);
        this.repository = AbstractGridContainerMenu.createRepositoryBuilder(this).build();
        this.playerInventory = playerInventory;
        this.grid = grid;
        this.grid.addWatcher(this, PlayerActor.class);
        this.synchronizer = NoopGridSynchronizer.INSTANCE;
        this.initStrategies((ServerPlayer)playerInventory.player);
    }

    private static ResourceRepositoryBuilder<GridResource> createRepositoryBuilder(GridSortingTypes.TrackedResourceProvider sortingContext) {
        return new ResourceRepositoryBuilderImpl<GridResource>(RefinedStorageApi.INSTANCE.getGridResourceRepositoryMapper(), GridSortingTypes.NAME.apply(sortingContext), GridSortingTypes.QUANTITY.apply(sortingContext));
    }

    public void onResourceUpdate(ResourceKey resource, long amount, @Nullable TrackedResource trackedResource) {
        LOGGER.debug("{} got updated with {}", (Object)resource, (Object)amount);
        this.repository.update(resource, amount);
        this.updateOrRemoveTrackedResource(resource, trackedResource);
    }

    @Override
    @Nullable
    public TrackedResource getTrackedResource(GridResource resource) {
        return resource.getTrackedResource(this::getTrackedResource);
    }

    @Nullable
    public TrackedResource getTrackedResource(ResourceKey resource) {
        return this.trackedResources.get(resource);
    }

    private void updateOrRemoveTrackedResource(ResourceKey resource, @Nullable TrackedResource trackedResource) {
        if (trackedResource == null) {
            this.trackedResources.remove(resource);
        } else {
            this.trackedResources.put(resource, trackedResource);
        }
    }

    public SortingDirection getSortingDirection() {
        return Platform.INSTANCE.getConfig().getGrid().getSortingDirection();
    }

    public void setSortingDirection(SortingDirection sortingDirection) {
        Platform.INSTANCE.getConfig().getGrid().setSortingDirection(sortingDirection);
        this.repository.setSort(Platform.INSTANCE.getConfig().getGrid().getSortingType().apply(this).apply(this.repository), sortingDirection);
        this.repository.sort();
    }

    public GridSortingTypes getSortingType() {
        return Platform.INSTANCE.getConfig().getGrid().getSortingType();
    }

    public void setSortingType(GridSortingTypes sortingType) {
        Platform.INSTANCE.getConfig().getGrid().setSortingType(sortingType);
        this.repository.setSort(sortingType.apply(this).apply(this.repository), Platform.INSTANCE.getConfig().getGrid().getSortingDirection());
        this.repository.sort();
    }

    public GridViewType getViewType() {
        return Platform.INSTANCE.getConfig().getGrid().getViewType();
    }

    public void setViewType(GridViewType viewType) {
        Platform.INSTANCE.getConfig().getGrid().setViewType(viewType);
        this.repository.sort();
    }

    public void setSearchBox(GridSearchBox searchBox) {
        searchBox.addListener(text -> {
            boolean valid = this.onSearchTextChanged((String)text);
            searchBox.setValid(valid);
        });
        if (Platform.INSTANCE.getConfig().getGrid().isRememberSearchQuery()) {
            searchBox.setValue(lastSearchQuery);
            searchBox.addListener(AbstractGridContainerMenu::updateLastSearchQuery);
        }
    }

    private boolean onSearchTextChanged(String text) {
        try {
            this.repository.setFilterAndSort(AbstractGridContainerMenu.andFilter(QUERY_PARSER.parse(text), this.createBaseFilter()));
            return true;
        }
        catch (GridQueryParserException e) {
            this.repository.setFilterAndSort((v, resource) -> false);
            return false;
        }
    }

    private ResourceRepositoryFilter<GridResource> createBaseFilter() {
        return AbstractGridContainerMenu.andFilter(this.createResourceTypeFilter(), this.createViewTypeFilter());
    }

    private ResourceRepositoryFilter<GridResource> createResourceTypeFilter() {
        return (v, resource) -> {
            if (!(resource instanceof GridResource)) return false;
            GridResource platformResource = resource;
            if (Platform.INSTANCE.getConfig().getGrid().getResourceType().flatMap(resourceTypeId -> RefinedStorageApi.INSTANCE.getResourceTypeRegistry().get((ResourceLocation)resourceTypeId).map(platformResource::belongsToResourceType)).orElse(true) == false) return false;
            return true;
        };
    }

    private ResourceRepositoryFilter<GridResource> createViewTypeFilter() {
        return (v, resource) -> Platform.INSTANCE.getConfig().getGrid().getViewType().accepts(resource.isAutocraftable((ResourceRepository<GridResource>)v));
    }

    private static ResourceRepositoryFilter<GridResource> andFilter(ResourceRepositoryFilter<GridResource> a, ResourceRepositoryFilter<GridResource> b) {
        return (view, resource) -> a.test((GridResource)view, resource) && b.test((GridResource)view, resource);
    }

    private static void updateLastSearchQuery(String text) {
        lastSearchQuery = text;
    }

    public void removed(Player playerEntity) {
        super.removed(playerEntity);
        if (this.grid != null) {
            this.grid.removeWatcher(this);
        }
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        this.resetSlots();
        this.addPlayerInventory(this.playerInventory, 8, playerInventoryY, (before, after) -> {
            Pattern beforePattern = RefinedStorageApi.INSTANCE.getPattern(before, this.playerInventory.player.level()).orElse(null);
            Pattern afterPattern = RefinedStorageApi.INSTANCE.getPattern(after, this.playerInventory.player.level()).orElse(null);
            if (beforePattern != null) {
                this.playerInventoryPatterns.remove(beforePattern);
            }
            if (afterPattern != null) {
                this.playerInventoryPatterns.add(afterPattern, 0);
            }
        });
    }

    public ResourceRepository<GridResource> getRepository() {
        return this.repository;
    }

    @Override
    public void onActiveChanged(boolean newActive) {
        this.active = newActive;
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            S2CPackets.sendGridActive(serverPlayerEntity, newActive);
        }
    }

    @Override
    public void onChanged(ResourceKey resource, long change, @Nullable TrackedResource trackedResource) {
        if (!(resource instanceof PlatformResourceKey)) {
            return;
        }
        PlatformResourceKey platformResource = (PlatformResourceKey)resource;
        LOGGER.debug("{} received a change of {} for {}", new Object[]{this, change, resource});
        S2CPackets.sendGridUpdate((ServerPlayer)this.playerInventory.player, platformResource, change, trackedResource);
    }

    @Override
    public void invalidate() {
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.initStrategies(serverPlayer);
            S2CPackets.sendGridClear(serverPlayer);
        }
    }

    private void initStrategies(ServerPlayer player) {
        this.insertionStrategy = RefinedStorageApi.INSTANCE.createGridInsertionStrategy(this, player, Objects.requireNonNull(this.grid));
        this.extractionStrategy = RefinedStorageApi.INSTANCE.createGridExtractionStrategy(this, player, Objects.requireNonNull(this.grid));
        this.scrollingStrategy = RefinedStorageApi.INSTANCE.createGridScrollingStrategy(this, player, Objects.requireNonNull(this.grid));
    }

    public boolean isActive() {
        return this.active;
    }

    private GridSynchronizer loadSynchronizer() {
        return Platform.INSTANCE.getConfig().getGrid().getSynchronizer().flatMap(id -> RefinedStorageApi.INSTANCE.getGridSynchronizerRegistry().get((ResourceLocation)id)).orElse(NoopGridSynchronizer.INSTANCE);
    }

    @Nullable
    private ResourceType loadResourceType() {
        return Platform.INSTANCE.getConfig().getGrid().getResourceType().flatMap(id -> RefinedStorageApi.INSTANCE.getResourceTypeRegistry().get((ResourceLocation)id)).orElse(null);
    }

    public GridSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Nullable
    public ResourceType getResourceType() {
        return this.resourceTypeFilter;
    }

    public void toggleSynchronizer() {
        PlatformRegistry<GridSynchronizer> registry = RefinedStorageApi.INSTANCE.getGridSynchronizerRegistry();
        Config.GridEntry config = Platform.INSTANCE.getConfig().getGrid();
        GridSynchronizer newSynchronizer = registry.nextOrNullIfLast(this.getSynchronizer());
        if (newSynchronizer == null) {
            config.clearSynchronizer();
        } else {
            registry.getId(newSynchronizer).ifPresent(config::setSynchronizer);
        }
        this.synchronizer = newSynchronizer == null ? NoopGridSynchronizer.INSTANCE : newSynchronizer;
    }

    public void toggleResourceType() {
        ResourceType newResourceType;
        PlatformRegistry<ResourceType> registry = RefinedStorageApi.INSTANCE.getResourceTypeRegistry();
        Config.GridEntry config = Platform.INSTANCE.getConfig().getGrid();
        ResourceType resourceType = newResourceType = this.resourceTypeFilter == null ? ResourceTypes.ITEM : registry.nextOrNullIfLast(this.resourceTypeFilter);
        if (newResourceType == null) {
            config.clearResourceType();
        } else {
            registry.getId(newResourceType).ifPresent(config::setResourceType);
        }
        this.resourceTypeFilter = newResourceType;
        this.repository.sort();
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        if (this.grid != null && !this.grid.isGridActive()) {
            return false;
        }
        if (this.insertionStrategy == null) {
            return false;
        }
        return this.insertionStrategy.onInsert(insertMode, tryAlternatives);
    }

    @Override
    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (this.grid != null && !this.grid.isGridActive()) {
            return false;
        }
        if (this.extractionStrategy == null) {
            return false;
        }
        return this.extractionStrategy.onExtract(resource, extractMode, cursor);
    }

    @Override
    public boolean onScroll(PlatformResourceKey resource, GridScrollMode scrollMode, int slotIndex) {
        if (this.grid != null && !this.grid.isGridActive()) {
            return false;
        }
        if (this.scrollingStrategy == null) {
            return false;
        }
        return this.scrollingStrategy.onScroll(resource, scrollMode, slotIndex);
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemStack quickMoveStack(Player playerEntity, int slotIndex) {
        Slot slot;
        if (this.transferManager.transfer(slotIndex)) {
            return ItemStack.EMPTY;
        }
        if (!playerEntity.level().isClientSide() && this.grid != null && this.grid.isGridActive() && (slot = this.getSlot(slotIndex)).hasItem() && this.insertionStrategy != null && this.canTransferSlot(slot)) {
            this.insertionStrategy.onTransfer(slot.index);
        }
        return ItemStack.EMPTY;
    }

    protected boolean canTransferSlot(Slot slot) {
        return true;
    }

    public void onClear() {
        this.repository.clear();
        this.trackedResources.clear();
    }

    @Nullable
    public final AutocraftableResourceHint getAutocraftableResourceHint(Slot slot) {
        ResourceKey resource = this.getResourceForAutocraftableHint(slot);
        if (resource == null) {
            return null;
        }
        return this.getAutocraftableResourceHint(resource);
    }

    @Nullable
    private AutocraftableResourceHint getAutocraftableResourceHint(ResourceKey resource) {
        if (this.repository.isSticky(resource)) {
            return AutocraftableResourceHint.AUTOCRAFTABLE;
        }
        if (this.playerInventoryPatterns.getOutputs().contains(resource)) {
            return AutocraftableResourceHint.PATTERN_IN_INVENTORY;
        }
        return null;
    }

    @Nullable
    protected ResourceKey getResourceForAutocraftableHint(Slot slot) {
        return null;
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount) {
        return Objects.requireNonNull(this.grid).getPreview(resource, amount);
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource) {
        return Objects.requireNonNull(this.grid).getMaxAmount(resource);
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify) {
        return Objects.requireNonNull(this.grid).startTask(resource, amount, actor, notify);
    }

    public boolean isLargeSlot(Slot slot) {
        return false;
    }
}

