/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.ClientCraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGridResultSlot;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;

public abstract class AbstractCraftingGridContainerMenu
extends AbstractGridContainerMenu {
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_FIRST_CRAFTING_MATRIX_SLOT = 69;
    private final Player gridPlayer;
    private final CraftingGrid craftingGrid;
    private final List<Slot> craftingMatrixSlots = new ArrayList<Slot>();
    @Nullable
    private Consumer<Boolean> activenessListener;
    @Nullable
    private ResourceRepositoryFilter<GridResource> filterBeforeFilteringBasedOnCraftingMatrixItems;

    protected AbstractCraftingGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, GridData gridData) {
        super(menuType, syncId, playerInventory, gridData);
        this.craftingGrid = new ClientCraftingGrid();
        this.gridPlayer = playerInventory.player;
    }

    protected AbstractCraftingGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, CraftingGrid craftingGrid) {
        super(menuType, syncId, playerInventory, craftingGrid);
        this.craftingGrid = craftingGrid;
        this.gridPlayer = playerInventory.player;
    }

    public void setActivenessListener(@Nullable Consumer<Boolean> activenessListener) {
        this.activenessListener = activenessListener;
    }

    @Override
    public void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (this.activenessListener != null) {
            this.activenessListener.accept(newActive);
        }
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof CraftingGridResultSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    @Override
    public ItemStack quickMoveStack(Player actor, int slotIndex) {
        CraftingGridResultSlot resultSlot;
        Slot slot = this.getSlot(slotIndex);
        if (!actor.level().isClientSide() && slot instanceof CraftingGridResultSlot && (resultSlot = (CraftingGridResultSlot)slot).hasItem()) {
            ItemStack craftedStack = resultSlot.onQuickCraft(actor);
            this.craftingGrid.acceptQuickCraft(actor, craftedStack);
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(actor, slotIndex);
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        super.resized(playerInventoryY, topYStart, topYEnd);
        this.craftingMatrixSlots.clear();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotX = 26 + x % 3 * 18;
                int slotY = playerInventoryY - 69 + y % 3 * 18;
                this.craftingMatrixSlots.add(this.addSlot(new Slot((Container)this.craftingGrid.getCraftingMatrix(), x + y * 3, slotX, slotY)));
            }
        }
        this.addSlot((Slot)new CraftingGridResultSlot(this.gridPlayer, this.craftingGrid, 134, playerInventoryY - 69 + 18));
    }

    public List<Slot> getCraftingMatrixSlots() {
        return this.craftingMatrixSlots;
    }

    public void clear(boolean toPlayerInventory) {
        this.craftingGrid.clearMatrix(this.gridPlayer, toPlayerInventory);
    }

    @API(status=API.Status.INTERNAL)
    public MutableResourceList getAvailableListForRecipeTransfer() {
        MutableResourceList available = this.getRepository().copyBackingList();
        this.addContainerToList((Container)this.craftingGrid.getCraftingMatrix(), available);
        this.addContainerToList((Container)this.gridPlayer.getInventory(), available);
        return available;
    }

    private void addContainerToList(Container container, MutableResourceList available) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            available.add(ItemResource.ofItemStack(stack), stack.getCount());
        }
    }

    public void transferRecipe(List<List<ItemResource>> recipe) {
        this.craftingGrid.transferRecipe(this.gridPlayer, recipe);
    }

    public void filterBasedOnCraftingMatrixItems() {
        Set<ItemResource> craftingMatrixItems = this.getCraftingMatrixItems();
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = this.getRepository().setFilterAndSort((view, resource) -> {
            ItemGridResource itemResource;
            return resource instanceof ItemGridResource && craftingMatrixItems.contains((itemResource = (ItemGridResource)resource).getItemResource());
        });
    }

    private Set<ItemResource> getCraftingMatrixItems() {
        HashSet<ItemResource> craftingMatrixItems = new HashSet<ItemResource>();
        for (int i = 0; i < this.craftingGrid.getCraftingMatrix().getContainerSize(); ++i) {
            ItemStack craftingMatrixStack = this.craftingGrid.getCraftingMatrix().getItem(i);
            if (craftingMatrixStack.isEmpty()) continue;
            craftingMatrixItems.add(ItemResource.ofItemStack(craftingMatrixStack));
        }
        return craftingMatrixItems;
    }

    public void stopFilteringBasedOnCraftingMatrixItems() {
        if (this.filterBeforeFilteringBasedOnCraftingMatrixItems == null) {
            return;
        }
        this.getRepository().setFilterAndSort(this.filterBeforeFilteringBasedOnCraftingMatrixItems);
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = null;
    }

    @Override
    @Nullable
    protected ResourceKey getResourceForAutocraftableHint(Slot slot) {
        if (slot.container == this.craftingGrid.getCraftingMatrix() || slot.container == this.craftingGrid.getCraftingResult()) {
            return ItemResource.ofItemStack(slot.getItem());
        }
        return super.getResourceForAutocraftableHint(slot);
    }

    @Override
    public boolean isLargeSlot(Slot slot) {
        return slot.container == this.craftingGrid.getCraftingResult() || super.isLargeSlot(slot);
    }
}

