/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.CompositeDestructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorContainerMenu;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorNetworkNode;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDestructorBlockEntity
extends AbstractCableLikeBlockEntity<DestructorNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_PICKUP_ITEMS = "pi";
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filterWithFuzzyMode = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractDestructorBlockEntity)this).setChanged(), this::setFilters);
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(UpgradeDestinations.DESTRUCTOR, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getDestructor().getEnergyUsage();
        ((DestructorNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.setChanged();
        Level patt0$temp = this.level;
        if (patt0$temp instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            this.initialize(serverLevel);
        }
    }, 20);
    private boolean pickupItems;

    protected AbstractDestructorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getDestructor(), pos, state, new DestructorNetworkNode(Platform.INSTANCE.getConfig().getDestructor().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public boolean isPickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean pickupItems) {
        this.pickupItems = pickupItems;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    void setFilters(Set<ResourceKey> filters) {
        ((DestructorNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    public FilterMode getFilterMode() {
        return ((DestructorNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    public void setFilterMode(FilterMode mode) {
        ((DestructorNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((DestructorNetworkNode)this.mainNetworkNode).getFilterMode()));
        tag.putBoolean(TAG_PICKUP_ITEMS, this.pickupItems);
        this.filterWithFuzzyMode.save(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filterWithFuzzyMode.load(tag, provider);
        if (tag.contains(TAG_FILTER_MODE)) {
            ((DestructorNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.getInt(TAG_FILTER_MODE)));
        }
        if (tag.contains(TAG_PICKUP_ITEMS)) {
            this.pickupItems = tag.getBoolean(TAG_PICKUP_ITEMS);
        }
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filterWithFuzzyMode.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.DESTRUCTOR);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new DestructorContainerMenu(syncId, player, this, this.filterWithFuzzyMode.getFilterContainer(), this.upgradeContainer);
    }

    @Override
    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ((DestructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((DestructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private CompositeDestructorStrategy createStrategy(ServerLevel level, Direction direction) {
        BlockPos pos = this.getBlockPos().relative(direction);
        Direction incomingDirection = direction.getOpposite();
        List<DestructorStrategy> strategies = RefinedStorageApi.INSTANCE.getDestructorStrategyFactories().stream().flatMap(factory -> factory.create(level, pos, incomingDirection, this.upgradeContainer, this.pickupItems).stream()).toList();
        return new CompositeDestructorStrategy(strategies);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

