/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.configurationcard;

import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.configurationcard.ConfigurationCardState;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ConfigurationCardItem
extends Item {
    private static final Component EMPTY_HELP = IdentifierUtil.createTranslation("item", "configuration_card.empty_help");
    private static final Component CONFIGURED_HELP = IdentifierUtil.createTranslation("item", "configuration_card.configured_help");
    private static final Component EMPTY = IdentifierUtil.createTranslation("item", "configuration_card.empty").withStyle(ChatFormatting.GRAY);

    public ConfigurationCardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide() || ctx.getPlayer() == null) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (!(blockEntity instanceof ConfigurationCardTarget)) {
            return InteractionResult.CONSUME;
        }
        ConfigurationCardTarget target = (ConfigurationCardTarget)blockEntity;
        ItemStack stack = ctx.getItemInHand();
        ConfigurationCardState state = (ConfigurationCardState)stack.get(DataComponents.INSTANCE.getConfigurationCardState());
        if (state == null) {
            stack.set(DataComponents.INSTANCE.getConfigurationCardState(), (Object)new ConfigurationCardState(blockEntity.getType(), this.createConfigTag(target, (HolderLookup.Provider)ctx.getLevel().registryAccess()), target.getUpgrades()));
            this.sendCopiedConfigurationMessage(ctx.getPlayer(), blockEntity.getType());
            return InteractionResult.CONSUME;
        }
        return this.applyConfiguration(ctx.getPlayer(), blockEntity, target, state, (HolderLookup.Provider)ctx.getLevel().registryAccess());
    }

    private InteractionResult applyConfiguration(Player player, BlockEntity targetBlockEntity, ConfigurationCardTarget target, ConfigurationCardState state, HolderLookup.Provider provider) {
        if (state.blockEntityType() != targetBlockEntity.getType()) {
            return this.configurationCardIsConfiguredForDifferentType(player, state.blockEntityType());
        }
        target.readConfiguration(state.config(), provider);
        this.tryTransferUpgrades(player, target, state.upgrades());
        targetBlockEntity.setChanged();
        player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "configuration_card.applied_configuration"));
        return InteractionResult.SUCCESS;
    }

    private void tryTransferUpgrades(Player player, ConfigurationCardTarget target, List<ItemStack> upgrades) {
        for (ItemStack upgrade : upgrades) {
            int upgradeIndexInPlayerInventory = player.getInventory().findSlotMatchingItem(upgrade);
            if (upgradeIndexInPlayerInventory < 0 || !target.addUpgrade(upgrade)) continue;
            player.getInventory().removeItem(upgradeIndexInPlayerInventory, 1);
        }
    }

    private InteractionResult configurationCardIsConfiguredForDifferentType(Player player, @Nullable BlockEntityType<?> existingConfiguredType) {
        if (existingConfiguredType != null) {
            player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "configuration_card.cannot_apply_configuration", ConfigurationCardItem.getConfiguredTypeTranslation(existingConfiguredType).withStyle(ChatFormatting.YELLOW)));
        }
        return InteractionResult.CONSUME;
    }

    private CompoundTag createConfigTag(ConfigurationCardTarget target, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        target.writeConfiguration(tag, provider);
        return tag;
    }

    private void sendCopiedConfigurationMessage(Player player, BlockEntityType<?> configuredType) {
        if (player.level().isClientSide()) {
            return;
        }
        player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "configuration_card.copied_configuration", ConfigurationCardItem.getConfiguredTypeTranslation(configuredType).withStyle(ChatFormatting.YELLOW)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            if (!level.isClientSide()) {
                player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "configuration_card.cleared_configuration"));
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)new ItemStack((ItemLike)this));
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        ConfigurationCardState state = (ConfigurationCardState)stack.get(DataComponents.INSTANCE.getConfigurationCardState());
        if (state == null) {
            lines.add(EMPTY);
            return;
        }
        lines.add((Component)IdentifierUtil.createTranslation("item", "configuration_card.configured", ConfigurationCardItem.getConfiguredTypeTranslation(state.blockEntityType()).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.GRAY));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.isActive(stack) ? CONFIGURED_HELP : EMPTY_HELP));
    }

    boolean isActive(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getConfigurationCardState());
    }

    private static MutableComponent getConfiguredTypeTranslation(BlockEntityType<?> type) {
        ResourceLocation typeId = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(type);
        if (typeId == null) {
            return Component.empty();
        }
        return Component.translatable((String)("block." + typeId.getNamespace() + "." + typeId.getPath()));
    }
}

