/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

class AutocraftingTaskButton
extends AbstractButton {
    private final TaskStatus.TaskInfo task;
    private final TextMarquee text;
    private final Consumer<TaskId> onPress;
    private final PercentageCompletedProvider percentageCompletedProvider;

    AutocraftingTaskButton(int x, int y, TaskStatus.TaskInfo task, Consumer<TaskId> onPress, PercentageCompletedProvider percentageCompletedProvider) {
        super(x, y, 64, 24, (Component)Component.empty());
        this.task = task;
        ResourceKey resource = task.resource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.text = new TextMarquee(rendering.getDisplayName(resource), 36, 0xFFFFFF, true, true);
        this.onPress = onPress;
        this.percentageCompletedProvider = percentageCompletedProvider;
    }

    TaskId getTaskId() {
        return this.task.id();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        this.renderResourceIcon(graphics);
        int yOffset = SmallText.isSmall() ? 5 : 3;
        int textX = this.getX() + 3 + 16 + 3;
        int textY = this.getY() + yOffset;
        this.text.render(graphics, textX, textY, Minecraft.getInstance().font, this.isHovered);
        int ySpacing = SmallText.isSmall() ? 7 : 8;
        long percentageCompleted = Math.round(this.percentageCompletedProvider.getPercentageCompleted(this.task.id()) * 100.0);
        SmallText.render(graphics, Minecraft.getInstance().font, percentageCompleted + "%", textX, textY + ySpacing, 0xFFFFFF, true, 0.5f);
        this.updateTooltip();
    }

    private void renderResourceIcon(GuiGraphics graphics) {
        ResourceKey resource = this.task.resource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        int resourceX = this.getX() + 3;
        int resourceY = this.getY() + 4;
        rendering.render(resource, graphics, resourceX, resourceY);
        ResourceSlotRendering.renderAmount(graphics, resourceX, resourceY, this.task.amount(), rendering);
    }

    private void updateTooltip() {
        if (this.isHovered) {
            String runningTime = this.getRunningTimeText();
            this.setTooltip(Tooltip.create((Component)IdentifierUtil.createTranslation("gui", "autocrafting_monitor.running_time", runningTime)));
        } else {
            this.setTooltip(null);
        }
    }

    private String getRunningTimeText() {
        int totalSecs = (int)(System.currentTimeMillis() - this.task.startTime()) / 1000;
        int hours = totalSecs / 3600;
        int minutes = totalSecs % 3600 / 60;
        int seconds = totalSecs % 60;
        String runningTime = hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
        return runningTime;
    }

    public void onPress() {
        this.onPress.accept(this.task.id());
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    static interface PercentageCompletedProvider {
        public double getPercentageCompleted(TaskId var1);
    }
}

