/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.upgrade;

import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.2")
public abstract class AbstractUpgradeItem
extends Item
implements UpgradeItem {
    private final UpgradeRegistry registry;
    private final Component helpText;

    protected AbstractUpgradeItem(Item.Properties properties, UpgradeRegistry registry, Component helpText) {
        super(properties);
        this.registry = registry;
        this.helpText = helpText;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        Set<UpgradeMapping> destinations = this.getDestinations();
        if (destinations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new UpgradeDestinationTooltipComponent(destinations, this.helpText));
    }

    protected final Set<UpgradeMapping> getDestinations() {
        return this.registry.getByUpgradeItem(this);
    }

    public record UpgradeDestinationTooltipComponent(Set<UpgradeMapping> destinations, Component helpText) implements TooltipComponent
    {
    }
}

