/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.externalstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.storage.AbstractConfiguredProxyStorage;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeAwareChild;
import com.refinedmods.refinedstorage.api.storage.composite.ParentComposite;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorage;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageListener;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageRepository;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

public class ExposedExternalStorage
extends AbstractConfiguredProxyStorage<ExternalStorage>
implements TrackedStorage,
ExternalStorageListener {
    private final Set<ParentComposite> parents = new HashSet<ParentComposite>();
    private final LongSupplier clock;
    @Nullable
    private TrackedStorageRepository trackingRepository;

    ExposedExternalStorage(StorageConfiguration config, LongSupplier clock) {
        super(config);
        this.clock = clock;
    }

    void setTrackingRepository(TrackedStorageRepository trackingRepository) {
        this.trackingRepository = trackingRepository;
    }

    @Nullable
    public ExternalStorageProvider getExternalStorageProvider() {
        ExternalStorage delegate = (ExternalStorage)this.getUnsafeDelegate();
        if (delegate == null) {
            return null;
        }
        return delegate.getProvider();
    }

    @Override
    public void onAddedIntoComposite(ParentComposite parentComposite) {
        this.parents.add(parentComposite);
        ExternalStorage delegate = (ExternalStorage)this.getUnsafeDelegate();
        if (delegate != null) {
            delegate.onAddedIntoComposite(parentComposite);
        }
    }

    @Override
    public void onRemovedFromComposite(ParentComposite parentComposite) {
        this.parents.remove(parentComposite);
        ExternalStorage delegate = (ExternalStorage)this.getUnsafeDelegate();
        if (delegate != null) {
            delegate.onRemovedFromComposite(parentComposite);
        }
    }

    @Override
    public CompositeAwareChild.Amount compositeInsert(ResourceKey resource, long amount, Action action, Actor actor) {
        CompositeAwareChild.Amount inserted = super.compositeInsert(resource, amount, action, actor);
        return inserted.withoutNotifyingList();
    }

    @Override
    public CompositeAwareChild.Amount compositeExtract(ResourceKey resource, long amount, Action action, Actor actor) {
        CompositeAwareChild.Amount extracted = super.compositeExtract(resource, amount, action, actor);
        return extracted.withoutNotifyingList();
    }

    @Override
    public void setDelegate(ExternalStorage newDelegate) {
        super.setDelegate(newDelegate);
        this.parents.forEach(parent -> {
            parent.onSourceAddedToChild(newDelegate);
            newDelegate.onAddedIntoComposite((ParentComposite)parent);
        });
    }

    @Override
    public void clearDelegate() {
        ExternalStorage delegate = (ExternalStorage)this.getDelegate();
        this.parents.forEach(parent -> {
            parent.onSourceRemovedFromChild(delegate);
            delegate.onRemovedFromComposite((ParentComposite)parent);
        });
        super.clearDelegate();
    }

    public boolean detectChanges() {
        ExternalStorage delegate = (ExternalStorage)this.getUnsafeDelegate();
        if (delegate == null) {
            return false;
        }
        return delegate.detectChanges();
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        if (this.trackingRepository == null) {
            return Optional.empty();
        }
        return this.trackingRepository.findTrackedResourceByActorType(resource, actorType);
    }

    @Override
    public void beforeDetectChanges(ResourceKey resource, Actor actor) {
        if (this.trackingRepository == null) {
            return;
        }
        this.trackingRepository.update(resource, actor, this.clock.getAsLong());
    }
}

