/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.exporter;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import java.util.function.ToLongFunction;

public class MissingResourcesListeningExporterTransferStrategy
implements ExporterTransferStrategy {
    private final ExporterTransferStrategy delegate;
    private final OnMissingResources onMissingResources;

    public MissingResourcesListeningExporterTransferStrategy(ExporterTransferStrategy delegate, OnMissingResources onMissingResources) {
        this.delegate = delegate;
        this.onMissingResources = onMissingResources;
    }

    @Override
    public ExporterTransferStrategy.Result transfer(ResourceKey resource, Actor actor, Network network) {
        ExporterTransferStrategy.Result result = this.delegate.transfer(resource, actor, network);
        if (result == ExporterTransferStrategy.Result.RESOURCE_MISSING) {
            return this.onMissingResources.onMissingResources(resource, actor, network);
        }
        return result;
    }

    @FunctionalInterface
    public static interface OnMissingResources {
        public ExporterTransferStrategy.Result onMissingResources(ResourceKey var1, Actor var2, Network var3);

        public static OnMissingResources scheduleAutocrafting(ToLongFunction<ResourceKey> taskAmountProvider) {
            return (resource, actor, network) -> {
                AutocraftingNetworkComponent autocrafting = network.getComponent(AutocraftingNetworkComponent.class);
                if (!autocrafting.getPatternsByOutput(resource).isEmpty()) {
                    long amount = taskAmountProvider.applyAsLong(resource);
                    if (amount <= 0L) {
                        return ExporterTransferStrategy.Result.DESTINATION_DOES_NOT_ACCEPT;
                    }
                    AutocraftingNetworkComponent.EnsureResult ensureResult = autocrafting.ensureTask(resource, amount, actor);
                    boolean success = ensureResult == AutocraftingNetworkComponent.EnsureResult.TASK_CREATED || ensureResult == AutocraftingNetworkComponent.EnsureResult.TASK_ALREADY_RUNNING;
                    return success ? ExporterTransferStrategy.Result.AUTOCRAFTING_STARTED : ExporterTransferStrategy.Result.AUTOCRAFTING_MISSING_RESOURCES;
                }
                return ExporterTransferStrategy.Result.RESOURCE_MISSING;
            };
        }
    }
}

