/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.detector;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorAmountStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import javax.annotation.Nullable;

public class DetectorNetworkNode
extends AbstractNetworkNode {
    private final long energyUsage;
    private long amount;
    private DetectorMode mode = DetectorMode.EQUAL;
    @Nullable
    private ResourceKey configuredResource;
    @Nullable
    private DetectorAmountStrategy amountStrategy;

    public DetectorNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }

    public void setConfiguredResource(@Nullable ResourceKey configuredResource) {
        this.configuredResource = configuredResource;
    }

    public DetectorMode getMode() {
        return this.mode;
    }

    public void setMode(DetectorMode mode) {
        this.mode = mode;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setAmountStrategy(@Nullable DetectorAmountStrategy amountStrategy) {
        this.amountStrategy = amountStrategy;
    }

    public boolean isActivated() {
        if (this.configuredResource == null || this.network == null || !this.isActive() || this.amountStrategy == null) {
            return false;
        }
        long amountInNetwork = this.amountStrategy.getAmount(this.network, this.configuredResource);
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case DetectorMode.UNDER -> {
                if (amountInNetwork < this.amount) {
                    yield true;
                }
                yield false;
            }
            case DetectorMode.EQUAL -> {
                if (amountInNetwork == this.amount) {
                    yield true;
                }
                yield false;
            }
            case DetectorMode.ABOVE -> amountInNetwork > this.amount;
        };
    }
}

