/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.PatternCycleDetectedException;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewCraftingCalculatorListener
implements CraftingCalculatorListener<PreviewBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewCraftingCalculatorListener.class);
    private final UUID listenerId = UUID.randomUUID();
    private PreviewBuilder builder;

    private PreviewCraftingCalculatorListener(PreviewBuilder builder) {
        LOGGER.debug("{} - Started calculation", (Object)this.listenerId);
        this.builder = builder;
    }

    public static Preview calculatePreview(CraftingCalculator calculator, ResourceKey resource, long amount) {
        PreviewCraftingCalculatorListener listener = new PreviewCraftingCalculatorListener(PreviewBuilder.create());
        try {
            calculator.calculate(resource, amount, listener);
        }
        catch (PatternCycleDetectedException e) {
            return new Preview(PreviewType.CYCLE_DETECTED, Collections.emptyList(), e.getPattern().layout().outputs());
        }
        catch (NumberOverflowDuringCalculationException e) {
            return new Preview(PreviewType.OVERFLOW, Collections.emptyList(), Collections.emptyList());
        }
        return listener.buildPreview();
    }

    @Override
    public CraftingCalculatorListener<PreviewBuilder> childCalculationStarted(Pattern childPattern, ResourceKey resource, Amount amount) {
        LOGGER.debug("{} - Child calculation starting for {}x {}", new Object[]{this.listenerId, amount, resource});
        PreviewBuilder copy = this.builder.copy();
        copy.addToCraft(resource, amount.getTotal());
        return new PreviewCraftingCalculatorListener(copy);
    }

    @Override
    public void childCalculationCompleted(CraftingCalculatorListener<PreviewBuilder> childListener) {
        LOGGER.debug("{} - Child calculation completed", (Object)this.listenerId);
        this.builder = childListener.getData();
    }

    @Override
    public void ingredientsExhausted(ResourceKey resource, long amount) {
        LOGGER.debug("{} - Ingredients exhausted for {}x {}", new Object[]{this.listenerId, amount, resource});
        this.builder.addMissing(resource, amount);
    }

    @Override
    public void ingredientUsed(Pattern ingredientPattern, int ingredientIndex, ResourceKey resource, long amount) {
    }

    @Override
    public void ingredientExtractedFromStorage(ResourceKey resource, long amount) {
        LOGGER.debug("{} - Extracted from storage: {} - {}", new Object[]{this.listenerId, resource, amount});
        this.builder.addAvailable(resource, amount);
    }

    @Override
    public PreviewBuilder getData() {
        return this.builder;
    }

    private Preview buildPreview() {
        return this.builder.build();
    }
}

