/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingState;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.List;
import java.util.Optional;

class IngredientState {
    private final long amount;
    private final List<ResourceKey> possibilities;
    private int pos;

    IngredientState(Ingredient ingredient, CraftingState state) {
        this.amount = ingredient.amount();
        this.possibilities = ingredient.inputs().stream().sorted(state.storageSorter()).sorted(state.internalStorageSorter()).toList();
    }

    ResourceKey get() {
        return this.possibilities.get(this.pos);
    }

    long amount() {
        return this.amount;
    }

    Optional<ResourceKey> cycle() {
        if (this.pos + 1 >= this.possibilities.size()) {
            return Optional.empty();
        }
        ++this.pos;
        return Optional.of(this.get());
    }
}

