/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingState;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.IngredientState;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.PatternCycleDetectedException;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class CraftingTree<T> {
    private final Pattern pattern;
    private final Amount amount;
    private final PatternRepository patternRepository;
    private final CraftingCalculatorListener<T> listener;
    private final Set<Pattern> activePatterns;
    private CraftingState craftingState;

    private CraftingTree(Pattern pattern, CraftingState craftingState, Amount amount, PatternRepository patternRepository, CraftingCalculatorListener<T> listener, Set<Pattern> activePatterns) {
        this.pattern = pattern;
        this.craftingState = craftingState;
        this.amount = amount;
        this.patternRepository = patternRepository;
        this.listener = listener;
        this.activePatterns = activePatterns;
    }

    static <T> CraftingTree<T> root(Pattern pattern, RootStorage rootStorage, Amount amount, PatternRepository patternRepository, CraftingCalculatorListener<T> listener) {
        CraftingState craftingState = CraftingState.of(rootStorage);
        return new CraftingTree<T>(pattern, craftingState, amount, patternRepository, listener, new HashSet<Pattern>());
    }

    static <T> CraftingTree<T> child(Pattern pattern, CraftingState parentState, ResourceKey resource, Amount amount, PatternRepository patternRepository, CraftingCalculatorListener<T> listener, Set<Pattern> activePatterns) {
        CraftingCalculatorListener<T> childListener = listener.childCalculationStarted(pattern, resource, amount);
        CraftingState childState = parentState.copy();
        return new CraftingTree<T>(pattern, childState, amount, patternRepository, childListener, activePatterns);
    }

    CalculationResult calculate() {
        if (!this.activePatterns.add(this.pattern)) {
            throw new PatternCycleDetectedException(this.pattern);
        }
        CalculationResult result = CalculationResult.SUCCESS;
        List<Ingredient> ingredients = this.pattern.layout().ingredients();
        for (int ingredientIndex = 0; ingredientIndex < ingredients.size(); ++ingredientIndex) {
            Ingredient ingredient = ingredients.get(ingredientIndex);
            IngredientState ingredientState = new IngredientState(ingredient, this.craftingState);
            CalculationResult ingredientResult = this.calculateIngredient(ingredientIndex, ingredientState);
            if (ingredientResult != CalculationResult.MISSING_RESOURCES) continue;
            result = CalculationResult.MISSING_RESOURCES;
        }
        this.craftingState.addOutputsToInternalStorage(this.pattern, this.amount);
        this.activePatterns.remove(this.pattern);
        return result;
    }

    private CalculationResult calculateIngredient(int ingredientIndex, IngredientState ingredientState) {
        CraftingState.ResourceState resourceState = this.craftingState.getResource(ingredientState.get());
        long remaining = ingredientState.amount() * this.amount.iterations();
        if (remaining < 0L) {
            throw new NumberOverflowDuringCalculationException();
        }
        while (remaining > 0L) {
            long toTake;
            if (resourceState.isInInternalStorage()) {
                toTake = Math.min(remaining, resourceState.inInternalStorage());
                this.craftingState.extractFromInternalStorage(resourceState.resource(), toTake);
                this.listener.ingredientUsed(this.pattern, ingredientIndex, resourceState.resource(), toTake);
                remaining -= toTake;
            }
            if (remaining > 0L && resourceState.isInStorage()) {
                toTake = Math.min(remaining, resourceState.inStorage());
                this.craftingState.extractFromStorage(resourceState.resource(), toTake);
                this.listener.ingredientExtractedFromStorage(resourceState.resource(), toTake);
                this.listener.ingredientUsed(this.pattern, ingredientIndex, resourceState.resource(), toTake);
                remaining -= toTake;
            }
            if (remaining <= 0L) continue;
            CraftingState.ResourceState newState = this.tryCalculateChild(ingredientState, resourceState, remaining);
            if (newState == null) {
                this.craftingState.extractFromInternalStorage(resourceState.resource(), remaining);
                return CalculationResult.MISSING_RESOURCES;
            }
            resourceState = newState;
        }
        return CalculationResult.SUCCESS;
    }

    @Nullable
    private CraftingState.ResourceState tryCalculateChild(IngredientState ingredientState, CraftingState.ResourceState resourceState, long remaining) {
        Collection<Pattern> childPatterns = this.patternRepository.getByOutput(resourceState.resource());
        if (!childPatterns.isEmpty()) {
            return this.calculateChild(ingredientState, remaining, childPatterns, resourceState);
        }
        return ingredientState.cycle().map(this.craftingState::getResource).orElseGet(() -> {
            this.listener.ingredientsExhausted(resourceState.resource(), remaining);
            return null;
        });
    }

    @Nullable
    private CraftingState.ResourceState calculateChild(IngredientState ingredientState, long remaining, Collection<Pattern> childPatterns, CraftingState.ResourceState resourceState) {
        ChildCalculationResult<T> result = this.calculateChild(remaining, childPatterns, resourceState);
        if (result.success) {
            this.craftingState = result.childTree.craftingState;
            CraftingState.ResourceState updatedResourceState = this.craftingState.getResource(resourceState.resource());
            this.listener.childCalculationCompleted(result.childTree.listener);
            return updatedResourceState;
        }
        return this.cycleToNextIngredientOrFail(ingredientState, resourceState, result);
    }

    private ChildCalculationResult<T> calculateChild(long remaining, Collection<Pattern> childPatterns, CraftingState.ResourceState resourceState) {
        CraftingTree<T> lastChildTree = null;
        for (Pattern childPattern : childPatterns) {
            Amount childAmount = Amount.of(childPattern, resourceState.resource(), remaining);
            CraftingTree<T> childTree = CraftingTree.child(childPattern, this.craftingState, resourceState.resource(), childAmount, this.patternRepository, this.listener, this.activePatterns);
            CalculationResult childResult = childTree.calculate();
            if (childResult == CalculationResult.MISSING_RESOURCES) {
                lastChildTree = childTree;
                continue;
            }
            return new ChildCalculationResult<T>(true, childTree);
        }
        return new ChildCalculationResult(false, Objects.requireNonNull(lastChildTree));
    }

    @Nullable
    private CraftingState.ResourceState cycleToNextIngredientOrFail(IngredientState ingredientState, CraftingState.ResourceState resourceState, ChildCalculationResult<T> childResult) {
        return ingredientState.cycle().map(this.craftingState::getResource).orElseGet(() -> {
            this.craftingState = childResult.childTree.craftingState;
            this.listener.childCalculationCompleted(childResult.childTree.listener);
            return null;
        });
    }

    static enum CalculationResult {
        SUCCESS,
        MISSING_RESOURCES;

    }

    private record ChildCalculationResult<T>(boolean success, CraftingTree<T> childTree) {
    }
}

