/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.recipemod;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import java.util.Optional;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;

public class JeiChemicalRecipeModIngredientConverter
implements RecipeModIngredientConverter {
    public Optional<PlatformResourceKey> convertToResource(Object ingredient) {
        if (ingredient instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)ingredient;
            return Optional.of(ChemicalResource.ofChemicalStack(stack));
        }
        return Optional.empty();
    }

    public Optional<ResourceAmount> convertToResourceAmount(Object ingredient) {
        if (ingredient instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)ingredient;
            return Optional.of(new ResourceAmount((ResourceKey)ChemicalResource.ofChemicalStack(stack), stack.getAmount()));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Object> convertToIngredient(PlatformResourceKey resourceKey) {
        Chemical chemical2;
        if (!(resourceKey instanceof ChemicalResource)) return Optional.empty();
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            chemical2 = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Optional.of(new ChemicalStack(chemical2, 1000L));
    }
}

