/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;

public class ChemicalUtil {
    private static final ResourceLocation CHEMICAL_HANDLER_ID = ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_handler");
    public static final BlockCapability<IChemicalHandler, @NullableType Direction> BLOCK_CAPABILITY = BlockCapability.createSided((ResourceLocation)CHEMICAL_HANDLER_ID, IChemicalHandler.class);
    public static final ItemCapability<IChemicalHandler, Void> ITEM_CAPABILITY = ItemCapability.createVoid((ResourceLocation)CHEMICAL_HANDLER_ID, IChemicalHandler.class);

    private ChemicalUtil() {
    }

    public static long getCurrentAmount(IChemicalHandler handler, ChemicalResource resource) {
        long amount = 0L;
        for (int i = 0; i < handler.getChemicalTanks(); ++i) {
            ChemicalStack tank = handler.getChemicalInTank(i);
            if (tank.getChemical() != resource.chemical()) continue;
            amount += tank.getAmount();
        }
        return amount;
    }

    public static mekanism.api.Action toMekanismAction(Action action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case Action.EXECUTE -> mekanism.api.Action.EXECUTE;
            case Action.SIMULATE -> mekanism.api.Action.SIMULATE;
        };
    }
}

