/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.mekanism.ChemicalCapabilityCache;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import mekanism.api.chemical.ChemicalStack;

public class ChemicalExtractableStorage
implements ExtractableStorage {
    private final ChemicalCapabilityCache capabilityCache;

    public ChemicalExtractableStorage(ChemicalCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof ChemicalResource)) {
            return 0L;
        }
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        return this.capabilityCache.getCapability().map(fluidHandler -> ChemicalUtil.getCurrentAmount(fluidHandler, chemicalResource)).orElse(0L);
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof ChemicalResource)) {
            return 0L;
        }
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        return this.capabilityCache.getCapability().map(chemicalHandler -> {
            ChemicalStack toExtractStack = new ChemicalStack(chemicalResource.chemical(), amount);
            ChemicalStack drained = chemicalHandler.extractChemical(toExtractStack, ChemicalUtil.toMekanismAction(action));
            return drained.getAmount();
        }).orElse(0L);
    }
}

