/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Inventories;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardItems;

public class RedstonePenItem
extends StandardItems.BaseItem {
    public RedstonePenItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        if (stack.getMaxDamage() > 0) {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.pen.tooltip.numstored", stack.getMaxDamage() - stack.getDamageValue()));
        } else {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.pen.tooltip.rsfrominventory"));
        }
        Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.isDamageableItem() && stack.getDamageValue() > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return stack.getMaxDamage() <= 0 ? 13 : 13 - Mth.clamp((int)Math.round(13.0f * (float)stack.getDamageValue() / (float)stack.getMaxDamage()), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        return 0x663333;
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return state.getBlock().defaultDestroyTime() < 0.5f ? 10000.0f : 0.0f;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack stack = player.getItemInHand(player.getUsedItemHand());
        if (!RedstonePenItem.isPen(stack)) {
            stack = player.getMainHandItem();
        }
        if (!RedstonePenItem.isPen(stack)) {
            stack = player.getOffhandItem();
        }
        if (RedstonePenItem.isPen(stack)) {
            this.attack(stack, pos, player);
        }
        return false;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        this.attack(stack, pos, player);
        return false;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockHitResult rtr;
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        Block block = state.getBlock();
        if (block instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track = (RedstoneTrack.RedstoneTrackBlock)block;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockHitResult rtr2 = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
            return track.modifySegments(state, world, pos, player, stack, hand, rtr2, false, true);
        }
        if (!RedstoneTrack.RedstoneTrackBlock.canBePlacedOnFace(state, world, pos, facing)) {
            return InteractionResult.FAIL;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos target_pos = pos.relative(facing);
        BlockState target_state = world.getBlockState(target_pos);
        Block block2 = target_state.getBlock();
        if (block2 instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track_block = (RedstoneTrack.RedstoneTrackBlock)block2;
            rtr = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), target_pos, context.isInside());
            return track_block.modifySegments(target_state, world, target_pos, player, stack, hand, rtr, false, true);
        }
        rtr = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), target_pos, context.isInside());
        BlockPlaceContext ctx = new BlockPlaceContext(player, context.getHand(), new ItemStack((ItemLike)Items.REDSTONE), rtr);
        BlockState rs_state = ModContent.references.TRACK_BLOCK.getStateForPlacement(ctx);
        if (rs_state == null) {
            return InteractionResult.FAIL;
        }
        if (!target_state.canBeReplaced(ctx)) {
            return InteractionResult.FAIL;
        }
        if (!world.setBlock(target_pos, rs_state, 19)) {
            return InteractionResult.FAIL;
        }
        BlockState placed_state = world.getBlockState(target_pos);
        Block block3 = placed_state.getBlock();
        if (block3 instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track_block = (RedstoneTrack.RedstoneTrackBlock)block3;
            return track_block.modifySegments(target_state, world, target_pos, player, stack, hand, rtr, false, true) == InteractionResult.FAIL ? InteractionResult.FAIL : InteractionResult.CONSUME;
        }
        world.removeBlock(target_pos, false);
        return InteractionResult.FAIL;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || !entity.isShiftKeyDown() || world.isClientSide() || (world.getGameTime() & 1L) != 0L || !(entity instanceof ServerPlayer)) {
            return;
        }
        HitResult rt = entity.pick(10.0, 0.0f, false);
        if (rt.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)rt;
        BlockPos pos = brtr.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        Direction rs_side = brtr.getDirection().getOpposite();
        MutableComponent tc = Component.empty();
        if (block == Blocks.REDSTONE_WIRE) {
            tc = Auxiliaries.localizable("overlay.wire_power", this.powerFormatted((Integer)state.getValue((Property)RedStoneWireBlock.POWER)));
        } else if (block == ModContent.references.TRACK_BLOCK) {
            RedstoneTrack.TrackBlockEntity te = RedstoneTrack.RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            tc = Auxiliaries.localizable("overlay.track_power", this.powerFormatted(te.getSidePower(rs_side)));
            if (Auxiliaries.isDevelopmentMode()) {
                tc.append((Component)Component.literal((String)String.format(" | flags: %016x, p: ", te.getStateFlags())));
                tc.append((Component)Component.literal((String)Arrays.stream(Direction.values()).map(side -> side.toString().substring(0, 1) + te.getRedstonePower(side.getOpposite(), false)).collect(Collectors.joining(","))));
            }
        } else if (state.is(Blocks.REPEATER)) {
            tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted((Boolean)state.getValue((Property)RepeaterBlock.POWERED) != false ? 15 : 0));
            tc.append((Component)Auxiliaries.localizable("overlay.repeater_delay", state.getValue((Property)RepeaterBlock.DELAY)));
        } else if (state.is(Blocks.COMPARATOR)) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof ComparatorBlockEntity) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(((ComparatorBlockEntity)te).getOutputSignal()));
                switch ((ComparatorMode)state.getValue((Property)ComparatorBlock.MODE)) {
                    case COMPARE: {
                        tc.append((Component)Auxiliaries.localizable("overlay.comparator_compare"));
                        break;
                    }
                    case SUBTRACT: {
                        tc.append((Component)Auxiliaries.localizable("overlay.comparator_subtract"));
                        break;
                    }
                }
            }
        } else if (state.isSignalSource()) {
            int p = Math.max(state.getDirectSignal((BlockGetter)world, pos, rs_side), state.getSignal((BlockGetter)world, pos, rs_side));
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p));
            } else {
                Direction max_side = null;
                for (Direction side2 : Direction.values()) {
                    int ps;
                    if (side2 == rs_side || (ps = Math.max(state.getDirectSignal((BlockGetter)world, pos, side2), state.getSignal((BlockGetter)world, pos, side2))) <= p) continue;
                    p = ps;
                    max_side = side2;
                    if (p >= 15) break;
                }
                tc = p == 0 || max_side == null ? Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p)) : Auxiliaries.localizable("overlay.direct_power_at", this.powerFormatted(p), max_side.getOpposite().toString());
            }
        } else if (RsSignals.canEmitWeakPower(state, world, pos, rs_side)) {
            Direction max_side = Direction.values()[0];
            int p = 0;
            for (Direction d : Direction.values()) {
                int ps = world.getSignal(pos.relative(d), d);
                if (ps <= p) continue;
                p = ps;
                max_side = d;
                if (p >= 15) break;
            }
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.indirect_power", this.powerFormatted(p), max_side.toString());
            }
        }
        if (Auxiliaries.isDevelopmentMode()) {
            String look_dir = Direction.orderedByNearest((Entity)entity)[0].toString().substring(0, 1);
            tc.append((Component)Component.literal((String)String.format(" | %s [%d,%d,%d]", look_dir, pos.getX(), pos.getY(), pos.getZ())));
        }
        Overlay.show((ServerPlayer)entity, (Component)tc, 400);
    }

    private boolean attack(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.getCommandSenderWorld();
        BlockState state = world.getBlockState(pos);
        if (state.is((Block)ModContent.references.TRACK_BLOCK)) {
            HitResult rt = player.pick(10.0, 0.0f, false);
            if (rt.getType() != HitResult.Type.BLOCK) {
                return false;
            }
            InteractionHand hand = player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == this ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            Block block = state.getBlock();
            if (!(block instanceof RedstoneTrack.RedstoneTrackBlock)) {
                return false;
            }
            RedstoneTrack.RedstoneTrackBlock track = (RedstoneTrack.RedstoneTrackBlock)block;
            track.modifySegments(state, player.getCommandSenderWorld(), pos, player, stack, hand, (BlockHitResult)rt, true, false);
            return true;
        }
        if (state.is(Blocks.REDSTONE_WIRE)) {
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.removeBlock(pos, false);
            return true;
        }
        return false;
    }

    public static void pushRedstone(ItemStack stack, int amount, Player player) {
        if (player.isCreative()) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.getMaxDamage() <= 0) {
                ItemStack remaining = Inventories.insert(player, new ItemStack((ItemLike)Items.REDSTONE, amount), false);
                if (!remaining.isEmpty()) {
                    Inventories.give(player, remaining);
                }
            } else if (stack.getDamageValue() >= amount) {
                stack.setDamageValue(stack.getDamageValue() - amount);
            } else {
                stack.setDamageValue(0);
                Inventories.give(player, new ItemStack((ItemLike)Items.REDSTONE, amount -= stack.getDamageValue()));
            }
        } else if (stack.getItem() == Items.REDSTONE) {
            if (stack.getCount() <= stack.getMaxStackSize() - amount) {
                stack.grow(amount);
            } else {
                Inventories.give(player, new ItemStack((ItemLike)Items.REDSTONE, amount));
            }
        } else {
            Inventories.give(player, new ItemStack((ItemLike)Items.REDSTONE, amount));
        }
    }

    public static int popRedstone(ItemStack stack, int amount, Player player, InteractionHand hand) {
        if (player.isCreative()) {
            return amount;
        }
        if (amount <= 0) {
            return 0;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.getMaxDamage() > 0) {
                int dmg = stack.getDamageValue() + amount;
                if (dmg >= stack.getMaxDamage()) {
                    amount = stack.getMaxDamage() - stack.getDamageValue();
                    player.setItemInHand(hand, ItemStack.EMPTY);
                } else {
                    stack.setDamageValue(dmg);
                }
            } else {
                amount = Inventories.extract(player, new ItemStack((ItemLike)Items.REDSTONE), amount, false).getCount();
            }
        } else if (stack.getItem() == Items.REDSTONE) {
            if (stack.getCount() <= amount) {
                amount = stack.getCount();
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                stack.shrink(amount);
            }
        }
        return amount;
    }

    public static boolean hasEnoughRedstone(ItemStack stack, int amount, Player player) {
        if (player.isCreative()) {
            return true;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.getMaxDamage() > 0) {
                return stack.getDamageValue() < stack.getMaxDamage() - amount;
            }
            return Inventories.extract(player, new ItemStack((ItemLike)Items.REDSTONE), amount, true).getCount() >= amount;
        }
        if (stack.getItem() == Items.REDSTONE) {
            return stack.getCount() >= amount;
        }
        return false;
    }

    public static boolean isFullRedstone(ItemStack stack) {
        if (RedstonePenItem.isPen(stack)) {
            return stack.getDamageValue() <= 0;
        }
        if (stack.getItem() == Items.REDSTONE) {
            return stack.getCount() >= stack.getMaxStackSize();
        }
        return false;
    }

    public static boolean isPen(ItemStack stack) {
        return stack.getItem() instanceof RedstonePenItem;
    }

    private String powerFormatted(int p) {
        return String.format("%02d", p);
    }
}

