/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.TagGenerator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

public class RegistrationTagsGenerator
extends TagGenerator {
    private static final Supplier<MultiPackResourceManager> SERVER_DATA_FIELD;
    private static final Gson GSON;
    private final RechiseledRegistrationImpl registration;
    private final Map<ResourceLocation, List<Block>> loadedTags = Maps.newHashMap();

    public RegistrationTagsGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().forEach(pair -> {
            RechiseledBlockBuilderImpl builder = (RechiseledBlockBuilderImpl)pair.left();
            RechiseledBlockTypeImpl type = (RechiseledBlockTypeImpl)pair.right();
            if (type.hasRegularVariant()) {
                this.addTags(builder, type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addTags(builder, type.getConnectingBlock());
            }
        });
    }

    private void addTags(RechiseledBlockBuilderImpl builder, Block block) {
        builder.tags.stream().map(x$0 -> this.blockTag((ResourceLocation)x$0)).forEach(tag -> tag.add((Object)block));
        if (builder.miningTagsFromBlock != null) {
            this.getTagsForBlock(builder.miningTagsFromBlock).stream().map(x$0 -> this.blockTag((ResourceLocation)x$0)).forEach(tag -> tag.add((Object)block));
        }
    }

    private Set<ResourceLocation> getTagsForBlock(Supplier<Block> block) {
        return Stream.of(BlockTags.MINEABLE_WITH_AXE, BlockTags.MINEABLE_WITH_HOE, BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.MINEABLE_WITH_SHOVEL, BlockTags.NEEDS_STONE_TOOL, BlockTags.NEEDS_IRON_TOOL, BlockTags.NEEDS_DIAMOND_TOOL).map(TagKey::location).filter(tag -> this.loadVanillaTag((ResourceLocation)tag).contains(block.get())).collect(Collectors.toSet());
    }

    private List<Block> loadVanillaTag(ResourceLocation location) {
        if (this.loadedTags.containsKey(location)) {
            return this.loadedTags.get(location);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        MultiPackResourceManager resourceManager = SERVER_DATA_FIELD.get();
        for (Resource resource : resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("tags/block/" + location.getPath() + ".json")))) {
            try {
                InputStream stream = resource.open();
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    JsonArray array = json.getAsJsonArray("values");
                    for (JsonElement element : array) {
                        String name = element.getAsString();
                        if (name.charAt(0) == '#') {
                            blocks.addAll(this.loadVanillaTag(ResourceLocation.parse((String)name.substring(1))));
                            continue;
                        }
                        ResourceLocation registryName = ResourceLocation.parse((String)name);
                        Block block = (Block)Registries.BLOCKS.getValue(registryName);
                        if (block == null) {
                            throw new JsonParseException("Unknown block '" + String.valueOf(registryName) + "' in '" + String.valueOf(location) + "'");
                        }
                        blocks.add(block);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loadedTags.put(location, blocks);
        return blocks;
    }

    public String getName() {
        return "Registration Tag Generator: " + this.modName;
    }

    static {
        try {
            Field existingFileHelper = DatagenModLoader.class.getDeclaredField("existingFileHelper");
            existingFileHelper.setAccessible(true);
            Field serverData = ExistingFileHelper.class.getDeclaredField("serverData");
            serverData.setAccessible(true);
            SERVER_DATA_FIELD = () -> {
                try {
                    return (MultiPackResourceManager)serverData.get(existingFileHelper.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        GSON = new GsonBuilder().create();
    }
}

