/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ChorusTotemItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"past").stat(StatData.builder((String)"chance").initialValue(0.02, 0.035).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"radius").initialValue(5.0, 7.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 11, 19).star(1, 11, 27).star(2, 3, 12).star(3, 19, 12).star(4, 13, 8).star(5, 9, 8).link(0, 1).link(1, 2).link(0, 2).link(0, 3).link(1, 3).link(4, 0).link(5, 0).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7322202).borderBottom(-14318989).build()).beams(BeamsData.builder().startColor(-6006785).endColor(6553816).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"past").initialValue(1).gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.END_LIKE, LootEntries.THE_END}).build()).build();
    }

    @EventBusSubscriber
    public static class ChorusTotemEvent {
        @SubscribeEvent
        public static void onDimensionChange(LivingDamageEvent.Post event) {
            ChorusTotemItem relic;
            LivingEntity attacker;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !((livingEntity = event.getSource().getEntity()) instanceof LivingEntity) || (attacker = livingEntity).getStringUUID().equals(player.getStringUUID())) {
                return;
            }
            Level level = player.getCommandSenderWorld();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.CHORUS_TOTEM.value()));
            RandomSource random = level.getRandom();
            Item item = stack.getItem();
            if (!(item instanceof ChorusTotemItem) || !(relic = (ChorusTotemItem)item).canPlayerUseAbility(player, stack, "past") || player.getHealth() < 1.0f || (double)(player.getMaxHealth() - player.getHealth()) * relic.getStatValue(stack, "past", "chance") < (double)random.nextFloat()) {
                return;
            }
            attacker.randomTeleport(attacker.getX(), attacker.getY(), attacker.getZ(), false);
            attacker.setDeltaMovement(0.0, 0.0, 0.0);
            ChorusTotemEvent.teleportPlayerToSafeSpot(attacker, level, (int)relic.getStatValue(stack, "past", "radius"));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer attackerPLayer = (ServerPlayer)attacker;
                NetworkHandler.sendToClient((CustomPacketPayload)new PacketItemActivation(stack), (ServerPlayer)attackerPLayer);
                level.playSound(null, (Entity)player, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }

        public static void teleportPlayerToSafeSpot(LivingEntity attacker, Level level, int maxRadius) {
            RandomSource random = attacker.getRandom();
            Vec3 oldPos = attacker.position();
            for (int radius = maxRadius; radius > 0; --radius) {
                double x = attacker.getX() + (double)(random.nextInt(radius * 2 + 1) - radius);
                double y = attacker.getY() + ((double)random.nextInt(radius * 2 + 1) - (double)radius / 2.0);
                double z = attacker.getZ() + (double)(random.nextInt(radius * 2 + 1) - radius);
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                while (targetPos.getY() > level.getMinBuildHeight() && !level.getBlockState(targetPos.below()).blocksMotion()) {
                    targetPos = targetPos.below();
                }
                if (!level.isEmptyBlock(targetPos.above())) continue;
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, oldPos.x, oldPos.y + 1.0, oldPos.z, 40, (double)-0.1f, 0.0, 0.0, 0.1);
                attacker.teleportTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)targetPos.getX() + 0.5, (double)(targetPos.getY() + 1), (double)targetPos.getZ() + 0.5, 40, 0.5, 0.5, 0.5, 0.1);
                ChorusTotemEvent.createLine(level, Vec3.atLowerCornerOf((Vec3i)targetPos), oldPos);
                break;
            }
        }

        public static void createLine(Level level, Vec3 start, Vec3 end) {
            Vec3 delta = end.subtract(start);
            Vec3 dir = delta.normalize();
            double amount = delta.length() * 5.0;
            for (double i = 0.0; i < amount; i += 1.0) {
                double progress = i * delta.length() / amount;
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, start.x + dir.x * progress, start.y + dir.y * progress + 1.0, start.z + dir.z * progress, 5, 0.1, -0.01, 0.1, 0.1);
            }
        }
    }
}

