/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import com.mojang.serialization.MapCodec;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.ItemUnloaderBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.block.manipulator.ManipulatorBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemUnloaderBlock
extends ManipulatorBlock<ItemUnloaderBlockEntity> {
    private static final MapCodec<ItemUnloaderBlock> CODEC = ItemUnloaderBlock.simpleCodec(ItemUnloaderBlock::new);

    public ItemUnloaderBlock(BlockBehaviour.Properties properties) {
        super(ItemUnloaderBlockEntity.class, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends ManipulatorBlock<ItemUnloaderBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    public Direction getFacing(BlockState blockState) {
        return Direction.UP;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ItemUnloaderBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : ItemUnloaderBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.ITEM_UNLOADER.get()), ManipulatorBlockEntity::serverTick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)Translations.Tips.ITEM_UNLOADER).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.PLACE_UNDER_TRACK).withStyle(ChatFormatting.RED));
    }
}

