/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.Predicates;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.entity.vehicle.locomotive.SteamLocomotive;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidLoaderBlockEntity
extends FluidManipulatorBlockEntity {
    private static final int RESET_WAIT = 200;
    private static final int TRANSFER_RATE = 20;
    private static final float MAX_PIPE_LENGTH = 1.25f;
    private static final float PIPE_INCREMENT = 0.01f;
    private static final Direction[] PULL_FROM = (Direction[])Stream.of(Direction.values()).filter(direction -> direction != Direction.DOWN).toArray(Direction[]::new);
    private float lastPipeLength;
    private float pipeLength;

    public FluidLoaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), blockPos, blockState);
    }

    private void resetPipeLength() {
        this.pipeLength = 0.0f;
    }

    public float getPipeLength(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.lastPipeLength, (float)this.pipeLength);
    }

    private void setPipeLength(float pipeLength) {
        this.lastPipeLength = this.pipeLength;
        this.pipeLength = pipeLength;
        this.syncToClient();
    }

    private void extendPipe() {
        float newPipeLength = this.isPipeExtended() ? 1.25f : this.pipeLength + 0.01f;
        this.setPipeLength(newPipeLength);
    }

    private void retractPipe() {
        float newPipeLength = this.isPipeRetracted() ? 0.0f : this.pipeLength - 0.01f;
        this.setPipeLength(newPipeLength);
    }

    private boolean isPipeExtended() {
        return this.pipeLength >= 1.25f;
    }

    private boolean isPipeRetracted() {
        return this.pipeLength <= 0.0f;
    }

    @Override
    protected void reset() {
        super.reset();
        AbstractMinecart abstractMinecart = this.currentCart;
        if (abstractMinecart instanceof FluidTransferHandler) {
            FluidTransferHandler handler = (FluidTransferHandler)abstractMinecart;
            handler.setFilling(false);
        }
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        this.tankManager.pull(FluidTools.findNeighbors(this.level, this.getBlockPos(), Predicates.notOfType(FluidLoaderBlockEntity.class), PULL_FROM), 0, 20);
    }

    @Override
    public Optional<AbstractMinecart> findCart() {
        return EntitySearcher.findMinecarts().box(builder -> builder.at(this.getBlockPos().below(2)).raiseCeiling(1.0).inflate(-0.1f)).stream(this.level).findAny();
    }

    @Override
    protected void waitForReset(@Nullable AbstractMinecart cart) {
        if (this.isPipeRetracted() && cart != null) {
            this.sendCart(cart);
        } else {
            this.retractPipe();
        }
    }

    @Override
    protected void onNoCart() {
        if (!this.isPipeRetracted()) {
            this.retractPipe();
        }
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
        boolean needsPipe;
        SteamLocomotive locomotive;
        if (cart instanceof SteamLocomotive && !(locomotive = (SteamLocomotive)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        IFluidHandler tankCart = FluidLoaderBlockEntity.getCartFluidHandler(cart, Direction.UP);
        if (tankCart == null) {
            return;
        }
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        boolean bl = needsPipe = (double)this.getBlockPos().getY() - cart.position().y() > 1.0;
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        if (cartNeedsFilling && (!needsPipe || this.isPipeExtended())) {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)tankCart, (IFluidHandler)this.tank, (int)((Integer)RailcraftConfig.SERVER.tankCartFluidTransferRate.get()), (boolean)true);
            this.setProcessing(!moved.isEmpty());
        } else {
            this.setProcessing(false);
        }
        if (this.isProcessing()) {
            this.setPowered(false);
        }
        if (cart instanceof FluidTransferHandler) {
            FluidTransferHandler fluidTransferHandler = (FluidTransferHandler)cart;
            fluidTransferHandler.setFilling(this.isProcessing());
        }
        if (!this.tank.getFluid().isEmpty() && tankCart.fill(this.tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) == 0) {
            this.setResetTimer(200);
        }
    }

    private boolean cartNeedsFilling(IFluidHandler cartFluidHandler) {
        FluidStack fluidStack = this.tank.getFluid();
        return !fluidStack.isEmpty() && cartFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        if (!this.isPipeRetracted()) {
            return true;
        }
        IFluidHandler cartFluidHandler = FluidLoaderBlockEntity.getCartFluidHandler(cart, Direction.UP);
        if (cartFluidHandler == null) {
            return false;
        }
        FluidStack fluid = this.getFluidHandled();
        if (fluid.isEmpty()) {
            return false;
        }
        return switch (this.getRedstoneMode()) {
            case ManipulatorBlockEntity.RedstoneMode.COMPLETE -> {
                if (cartFluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    yield true;
                }
                yield false;
            }
            case ManipulatorBlockEntity.RedstoneMode.PARTIAL -> {
                if (!cartFluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void setPowered(boolean powered) {
        if (this.isManualMode()) {
            powered = false;
        }
        super.setPowered(powered);
    }

    @Override
    protected FluidTools.ProcessType getProcessType() {
        return FluidTools.ProcessType.DRAIN_ONLY;
    }

    public void setRemoved() {
        super.setRemoved();
        this.resetPipeLength();
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.resetPipeLength();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("pipeLength", this.pipeLength);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.pipeLength = tag.getFloat("pipeLength");
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeFloat(this.pipeLength);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.setPipeLength(data.readFloat());
    }
}

