/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.Translations;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.detector.ItemDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemDetectorBlockEntity
extends FilterDetectorBlockEntity {
    private PrimaryMode primaryMode = PrimaryMode.ANYTHING;
    private FilterMode filterMode = FilterMode.AT_LEAST;

    public ItemDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ITEM_DETECTOR.get(), blockPos, blockState, 9);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        block8: for (AbstractMinecart cart : minecarts) {
            IItemHandler itemHandler = (IItemHandler)cart.getCapability(Capabilities.ItemHandler.ENTITY);
            if (itemHandler == null) continue;
            ContainerManipulator<SlotAccessor> containerManipulator = ContainerManipulator.of(itemHandler);
            if (itemHandler.getSlots() <= 0) continue;
            switch (this.primaryMode.ordinal()) {
                case 2: {
                    return 15;
                }
                case 0: {
                    if (!containerManipulator.hasNoItems()) continue block8;
                    return 15;
                }
                case 1: {
                    if (!containerManipulator.isFull()) continue block8;
                    return 15;
                }
                case 3: {
                    if (!this.matchesFilter(containerManipulator)) continue block8;
                    return 15;
                }
                case 4: {
                    if (!containerManipulator.hasItems()) continue block8;
                    return 15;
                }
                case 5: {
                    return containerManipulator.calcRedstone();
                }
            }
        }
        return 0;
    }

    private boolean matchesFilter(ContainerManipulator<SlotAccessor> containerManipulator) {
        block7: for (int i = 0; i < this.invFilters.getContainerSize(); ++i) {
            ItemStack filter = this.invFilters.getItem(i);
            if (filter.isEmpty()) continue;
            Predicate<ItemStack> stackFilter = StackFilter.anyMatch(filter);
            int amountFilter = this.stream().filter(x -> x.matches(stackFilter)).map(x -> x.item().getCount()).reduce(Integer::sum).orElse(0);
            int amountCart = containerManipulator.countItems(stackFilter);
            switch (this.filterMode.ordinal()) {
                case 2: {
                    if (amountCart == amountFilter) continue block7;
                    return false;
                }
                case 0: {
                    if (amountCart >= amountFilter) continue block7;
                    return false;
                }
                case 1: {
                    if (amountCart <= amountFilter) continue block7;
                    return false;
                }
                case 4: {
                    if (amountCart > amountFilter) continue block7;
                    return false;
                }
                case 3: {
                    if (amountCart < amountFilter) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.primaryMode = PrimaryMode.fromName(tag.getString("primaryMode"));
        this.filterMode = FilterMode.fromName(tag.getString("filterMode"));
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("primaryMode", this.primaryMode.getSerializedName());
        tag.putString("filterMode", this.filterMode.getSerializedName());
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeEnum((Enum)this.primaryMode);
        out.writeEnum((Enum)this.filterMode);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.primaryMode = (PrimaryMode)in.readEnum(PrimaryMode.class);
        this.filterMode = (FilterMode)in.readEnum(FilterMode.class);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ItemDetectorMenu(id, inventory, this);
    }

    public PrimaryMode getPrimaryMode() {
        return this.primaryMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setPrimaryMode(PrimaryMode value) {
        this.primaryMode = value;
    }

    public void setFilterMode(FilterMode value) {
        this.filterMode = value;
    }

    public static enum PrimaryMode implements StringRepresentable
    {
        EMPTY("empty"),
        FULL("full"),
        ANYTHING("anything"),
        FILTERED("filtered"),
        NOT_EMPTY("not_empty"),
        ANALOG("analog");

        private static final StringRepresentable.EnumCodec<PrimaryMode> CODEC;
        private final String name;

        private PrimaryMode(String name) {
            this.name = name;
        }

        public PrimaryMode next() {
            return (PrimaryMode)EnumUtil.next((Enum)this, (Enum[])PrimaryMode.values());
        }

        public PrimaryMode previous() {
            return (PrimaryMode)EnumUtil.previous((Enum)this, (Enum[])PrimaryMode.values());
        }

        public Component getName() {
            return Component.translatable((String)Translations.makeKey("screen", "item_detector.primary_mode." + this.name));
        }

        public String getSerializedName() {
            return this.name;
        }

        public static PrimaryMode fromName(String name) {
            return (PrimaryMode)CODEC.byName(name, (Enum)ANYTHING);
        }

        static {
            CODEC = StringRepresentable.fromEnum(PrimaryMode::values);
        }
    }

    public static enum FilterMode implements StringRepresentable
    {
        AT_LEAST("at_least"),
        AT_MOST("at_most"),
        EXACTLY("exactly"),
        LESS_THAN("less_than"),
        GREATER_THAN("greater_than");

        private static final StringRepresentable.EnumCodec<FilterMode> CODEC;
        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public FilterMode next() {
            return (FilterMode)EnumUtil.next((Enum)this, (Enum[])FilterMode.values());
        }

        public FilterMode previous() {
            return (FilterMode)EnumUtil.previous((Enum)this, (Enum[])FilterMode.values());
        }

        public Component getName() {
            return Component.translatable((String)Translations.makeKey("screen", "item_detector.filter_mode." + this.name));
        }

        public String getSerializedName() {
            return this.name;
        }

        public static FilterMode fromName(String name) {
            return (FilterMode)CODEC.byName(name, (Enum)AT_LEAST);
        }

        static {
            CODEC = StringRepresentable.fromEnum(FilterMode::values);
        }
    }
}

